% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colformat.R
\name{colformat_md}
\alias{colformat_md}
\title{Format character columns as markdown text}
\usage{
colformat_md(
  x,
  j = where(is.character),
  part = c("body", "header", "all"),
  auto_color_link = "blue",
  md_extensions = NULL,
  pandoc_args = NULL,
  metadata = rmarkdown::metadata,
  replace_na = "",
  .from = "markdown+autolink_bare_uris-raw_html-raw_attribute",
  .footnote_options = footnote_options(),
  .sep = "\\n\\n"
)
}
\arguments{
\item{x}{A \code{flextable} object}

\item{j}{Columns to be treated as markdown texts.
Selection can be done by the semantics of \code{dplyr::select()}.}

\item{part}{One of "body", "header", and "all". If "all", formatting proceeds in the
order of "header" and "body".}

\item{auto_color_link}{A color of the link texts.}

\item{md_extensions}{Pandoc's extensions. Although it is prefixed with "md", extensions for any
formats specified to \code{.from} can be used. See
\url{https://www.pandoc.org/MANUAL.html#extensions} for details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{metadata}{A list of metadata, typically the parsed result of the YAML front matter
(default: \code{rmarkdown::metadata}). This value is used iff the \code{.from}
argument specifies the input format that supports the YAML metadata blocks.}

\item{replace_na}{A value to replace \code{NA} (default = \code{""}).}

\item{.from}{Pandoc's \code{--from} argument (default: \code{'markdown+autolink_bare_uris'}).}

\item{.footnote_options}{Options for footnotes generated by \code{footnote_options()}.}

\item{.sep}{A separator of paragraphs (default: \code{"\\n\\n"})}
}
\description{
Format character columns as markdown text
}
\examples{
if (rmarkdown::pandoc_available("2.0.6")) {
  d <- data.frame(
    x = c("**bold**", "*italic*"),
    y = c("^superscript^", "~subscript~"),
    z = c("***^ft^~Extra~** is*", "*Cool*")
  )
  colformat_md(flextable::flextable(d))
}
}
