% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spmplot.R
\name{spmplot}
\alias{spmplot}
\title{Interactive scatterplot matrix}
\usage{
spmplot(
  X,
  group,
  plot,
  variables,
  col,
  cex,
  pch,
  labeladd,
  label,
  legend,
  dispopt = c("hist", "box"),
  tag,
  datatooltip,
  databrush,
  trace = FALSE,
  ...
)
}
\arguments{
\item{X}{data matrix (2D array) containing \code{n} observations on \code{p} variables
or an object of S3 class \code{\link{fsmeda.object}} returned by
\code{\link{fsmult}} with \code{monitoring=TRUE} - a list containing
the monitoring of minimum Mahalanobis distance}

\item{group}{grouping variable. Vector with \code{n} elements. Specifies
a grouping variable defined as a categorical variable (factor), numeric, or array of strings,
or string matrix, and it must have the same number of rows as \code{X}.
This grouping variable determines the marker and color assigned to each point.
Remark: if \code{group} is used to distinguish a set of outliers from
a set of good units, the id number for the outliers should be the larger
(see optional field \code{labeladd} of parameter \code{plot} for details).}

\item{plot}{controls the names which are displayed in the margins of the
scatter-plot matrix, the labels of the legend the colors and the symbols.
If \code{plot} is \emph{empty} (\code{plot=FALSE} or \code{plot=0} or \code{plot=c()}
or \code{plot=NULL}) empty strings are displayed and no label and no name is added
to the plot. If \code{plot=TRUE} or \code{plot=1}, the names \code{Y1,..., Yp}
are added to the margins of the the scatter plot matrix else nothing is added.
If \code{plot} is a list, it is possible to control not only the names but also,
point labels, colors and symbols. More precisely list \code{plot} may contain the following elements:
   \enumerate{
   \item \code{labeladd} - see parameter \code{labeladd}
   \item \code{nameY} - a character string containing the labels of
        the variables. As default value, the labels which are
        added are \code{Y1, ..., Yp}. See parameter \code{variables}.
   \item \code{clr} - see parameter \code{col}
   \item \code{sym} - see parameter \code{pch}
   \item \code{siz} - see parameter \code{cex}
   \item \code{doleg} - see parameter \code{legend}
   \item \code{label} - see parameter \code{label}
   }}

\item{variables}{a character string with the names of the variables}

\item{col}{color specification for the data point. Can be different for each group.
By default, the order of the colors is \emph{blue}, \emph{red}, \emph{black},
\emph{magenta}, \emph{green}, \emph{cyan} and \emph{yelow}.}

\item{cex}{the size of the symbols used for plotting. By default \code{cex=1}
the symbol size depends on the number of plots and the size of the
figure window. Values larger than 1 will increase the size and
values smaller than 1 will decrease the size.}

\item{pch}{specification of the symbols to use. For example, if
there are three groups, and \code{pch=c(1, 3, 4)}, the first group will be
plotted with a circle, the second with a plus, and the third with a 'x' (see \code{?pch} or \code{?points} for
a list of symbols. NOTE: not all symbols available in R can be mapped to the symbols in MATLAB.}

\item{labeladd}{logical, controls wheather the elements belonging to the last group
in the scatterplot matrix are labelled with their unit row index
or their rowname. The rowname is taken from the parameter \code{label}
or if it is missing, from the sequence \code{1:n}. The default value is
\code{labeladd=FALSE}, i.e. no label is added.}

\item{label}{a character vector of length \code{n} (the number of rows in the data matrix)
containing the labels of the units. If this field is empty
the sequence \code{1:n} will be used to label the units.}

\item{legend}{logical, controls where a legend is shown or not.}

\item{dispopt}{controls how to fill the diagonals in the plot (main diagonal of
 the scatter plot matrix). Set \code{dispopt='hist'} (default) to plot histograms,
or \code{dispopt='box'} to plot boxplots. The style which is used for univariate
boxplots is traditional, if the number of groups is less or equal 5, else it is
'compact' (plot boxes using a smaller box style designed for plots with many groups).}

\item{tag}{Plot handle. String which identifies the handle of the plot which is about to be created.
The default is \code{tag='pl_mmd'}. Notice that if the program finds a plot which has
a tag equal to the one specified by the user, then the output of the new plot overwrites
the existing one in the same window else a new window is created.}

\item{datatooltip}{If datatooltip is not empty the user can use the mouse in order to have
information about the unit selected, the step in which the unit enters the search and
the associated label. If datatooltip is a list, it is possible to control the aspect
of the data cursor (see MATLAB function \code{datacursormode()} for more details or
see the examples below). The default options are \code{DisplayStyle="Window"} and \code{SnapToDataVertex="on"}.}

\item{databrush}{Interactive mouse brushing. If databrush is missing or empty (default), no brushing is done.
 The activation of this option (databrush is TRUE or a list) enables the user to select
   a set of trajectories in the current plot and to see them highlighted in the scatterplot matrix.
   If the scatterplot matrix does not exist it is automatically created.
   In addition, brushed units can be highlighted in the monitoring MD plot.
   Note that the window
   style of the other figures is set equal to that which contains the monitoring residual plot.
   In other words, if the monitoring residual plot is docked all the other figures will be docked too.

   If \code{databrush=TRUE} the default selection tool is a rectangular brush and it is
   possible to brush only once (that is persist='').

   If \code{databrush=list(...)}, it is possible to use all optional arguments of
   the MATLAB function \code{selectdataFS()} and the following optional arguments:
   \itemize{
   \item \code{persist}: This option can be an empty value or a character containing 'on' or 'off'.
       The default value is \code{persist=""}, that is brushing is allowed only once.
       If \code{persist="on"} or \code{persis="off"} brushing can be done as many time as
       the user requires. If \code{persist='on'} then the unit(s) currently brushed are
       added to those previously brushed. It is possible, every time a new brushing is
       done, to use a different color for the brushed units. If \code{persist='off'}
       every time a new brush is performed units previously brushed are removed.
   \item \code{labeladd}: add labels of brushed units in the scatterplot matrix.
       If this option is '1', we label the units of the last selected group with
       the unit row index in the matrix X. The default value is labeladd='',
       i.e. no label is added.
   }}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{...}{potential further arguments passed to lower level functions.}
}
\value{
none
}
\description{
Produces an interactive scatterplot matrix with boxplots or histograms on the main
 diagonal and possibly robust bivariate contours
}
\examples{

 \dontrun{
 ##  Call of spmplot() without optional parameters.
 ##  Iris data: scatter plot matrix with univariate boxplots on the main
 ##  diagonal.

 X <- iris[,1:4]
 group <- iris[,5]
 spmplot(X, group, variables=c('SL','SW','PL','PW'), dispopt="box")


 ##  Example of spmplot() called by routine fsmult().
 ##  Generate contaminated data.
     n <- 200; p <- 3
     X <- matrix(rnorm(n*p), ncol=3)
     Xcont <- X
     Xcont[1:5,] <- Xcont[1:5,] + 3

 ##  spmplot is called automatically by all outlier detection methods, e.g. fsmult()
     out <- fsmult(Xcont, plot=TRUE);

 ##  Now test the direct use of fsmult(). Set two groups, e.g. those obtained
 ##  from fsmult().

     group = rep(0, n)
     group[out$outliers] <- 1
 ##  option 'labeladd' is used to label the outliers
 ##  By default, the legend identifies the groups with the identifiers
 ##  given in vector 'group'.
 ##  Set the colors for the two groups to blue and red.

     spmplot(Xcont, group, col=c("blue", "red"), labeladd=1, dispopt="box")
 }

}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
