% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglactions.R
\name{limit_fun_na_inside}
\alias{limit_fun_na_inside}
\title{Get data limiting function, setting values inside range to NA.}
\usage{
limit_fun_na_inside(vmin, vmax)
}
\arguments{
\item{vmin}{numerical scalar, the lower border. Data values between this and vmax will be set to `NA` in the return value.}

\item{vmax}{numerical scalar, the upper border. See 'vmin'.}
}
\value{
a function that takes as argument the data, and clips it to the requested range. I.e., values inside the range will be set to `NA`. Designed to be used as \code{rglactions$trans_fun} in vis functions.
}
\description{
Get data limiting function to use in \code{\link{rglactions}} as 'trans_fun' to transform data.
}
\note{
This is useful for thresholding data plotted with a background. All values inside the range will set to NA and be transparent, and thus be displayed as the background color.
}
\examples{
   rglactions = list("trans_fun"=limit_fun_na_inside(2,3));

}
\seealso{
\code{\link{limit_fun_na}} which will set the values outside the range to `NA`.
}
