% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_potential.R
\name{color_potential}
\alias{color_potential}
\title{Evaluation of weather conditions for anthocyanin formation
in apple skin}
\usage{
color_potential(climdata, harvest)
}
\arguments{
\item{climdata}{a dataframe with daily maximum and minimum temperatures.
Must contain the columns Year, Month, Day, Tmax, Tmin.}

\item{harvest}{a vector with expected harvest days
(expressed as day of the year)}
}
\value{
dataframe with the number of highly favorable (Cool_d) 
and unfavorable (Hot_d) days for apple red color, as well as the 
average of the maximum (Tmax_avg) and minimum (Tmin_avg) 
temperatures for each year (Year) in the series during the 
30 days previous to each harvest date (Day_h) provided.
}
\description{
This function estimates the number of days that can be 
considered as highly favorable or unfavorable for anthocyanin 
accumulation in the skin of red apple cultivars during the 
month (30 days) before harvest. A highly favorable day (Cool
day) is considered when the daily maximum temperature is below
26ºC, a highly unfavorable day (Hot day) when the minimum 
temperature is above 20ºC (Lin-Wang et al, 2011). The average
of maximum and minimum temperatures during the same period is 
also provided. The function allows testing for several harvest 
dates.
}
\examples{

# Select the appropiate columns from Tudela_DW example dataset, create
# a vector or harvest dates and estimate the number favorable and 
# unfavorable days on each year in the dataset.
library(tidyverse)
Weather <- Tudela_DW \%>\%
   select(Year, Month, Day, Tmax, Tmin)
harvest <- c(225, 250, 275)
Color_assess <- color_potential(Weather, harvest)

}
\references{
Lin-Wang K, Micheletti D et al, 2011. High temperature reduces apple fruit
colour via modulation of the anthocyanin regulatory complex. Plant, Cell
and Environment 34, 1176-1190.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
