% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_save.R
\name{file_save}
\alias{file_save}
\title{Create a Copy of a File}
\usage{
file_save(
  x,
  file_extension_pattern = "\\\\.[A-z]{1,5}$",
  force = TRUE,
  recursive = dir.exists(x),
  stop_on_error = TRUE
)
}
\arguments{
\item{x}{A path to a file.}

\item{file_extension_pattern}{A Pattern to mark a file extension. If matched,
the time stamp will get inserted before that pattern.}

\item{force}{Force even if \code{file_extension_pattern} is not matched. Set
to \code{\link{FALSE}} to skip stamping such files.}

\item{recursive}{Passed to \code{\link{file.copy}}.}

\item{stop_on_error}{Throw an exception on error?}
}
\value{
\code{\link[base:TRUE]{TRUE}} on success, 
\code{\link[base:FALSE]{FALSE}} otherwise.
}
\description{
I often want a timestamped copy as backup of a file or directory.
}
\examples{
f <- tempfile()
try(file_save(f))
touch(f)
file_save(f, recursive = FALSE)
f <- paste0(file.path(tempfile()), ".txt")
touch(f)
file_save(f) # file.copy gives a warning
dir(tempdir())
}
\seealso{
Other operating system functions: 
\code{\link{file_copy}()},
\code{\link{get_boolean_envvar}()},
\code{\link{get_run_r_tests}()},
\code{\link{is_installed}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_success}()},
\code{\link{is_windows}()},
\code{\link{view}()},
\code{\link{vim}()},
\code{\link{with_dir}()}

Other file utilities: 
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
\concept{operating system functions}
