% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean.R
\name{is_not_false}
\alias{is_not_false}
\title{Test if an Object is Not \emph{FALSE}}
\usage{
is_not_false(x, null_is_false = TRUE, ...)
}
\arguments{
\item{x}{The object to be tested.}

\item{null_is_false}{Should \code{\link[base:NULL]{NULL}} be treated as
\code{\link[base:FALSE]{FALSE}}?}

\item{...}{Parameters passed to \code{\link{exists}}. See Examples.}
}
\value{
\code{\link[base:TRUE]{TRUE}} if the object is set to something
different than \code{\link[base:FALSE]{FALSE}},
\code{\link[base:FALSE]{FALSE}}
otherwise.
}
\description{
Sometimes you need to know whether or not an object exists and is not set to
\code{\link[base:FALSE]{FALSE}} (and possibly not
\code{\link[base:NULL]{NULL}}).
}
\examples{
a  <- 1
is_not_false(a)
f <- function() {
    print(a)
    print(is_not_false(a))
}
f()

f <- function() {
    a <- FALSE
    print(a)
    print(is_not_false(a))
}
f()

f <- function() {
    print(a)
    print(is_not_false(a, null_is_false = TRUE,
                       inherits = FALSE))
}
f()
}
\seealso{
Other logical helpers: 
\code{\link{is_false}()},
\code{\link{is_null_or_true}()}
}
\concept{logical helpers}
