% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_panel}
\alias{bs_vars_panel}
\title{Bootstrap panel variables}
\usage{
bs_vars_panel(
  bg = NULL,
  body_padding = NULL,
  heading_padding = NULL,
  footer_padding = NULL,
  border_radius = NULL,
  inner_border = NULL,
  footer_bg = NULL,
  default_text = NULL,
  default_border = NULL,
  default_heading_bg = NULL,
  primary_text = NULL,
  primary_border = NULL,
  primary_heading_bg = NULL,
  success_text = NULL,
  success_border = NULL,
  success_heading_bg = NULL,
  info_text = NULL,
  info_border = NULL,
  info_heading_bg = NULL,
  warning_text = NULL,
  warning_border = NULL,
  warning_heading_bg = NULL,
  danger_text = NULL,
  danger_border = NULL,
  danger_heading_bg = NULL
)
}
\arguments{
\item{bg}{Background color.}

\item{body_padding}{Panel body padding.}

\item{heading_padding}{Panel heading padding.}

\item{footer_padding}{Panel footer padding.}

\item{border_radius}{Variable for setting rounded corners on panel.}

\item{inner_border}{Border color for inner elements in panel.}

\item{footer_bg}{Panel footer background color.}

\item{default_text}{Default color for text.}

\item{default_border}{Default border color.}

\item{default_heading_bg}{Default background color for panel heading.}

\item{primary_text}{Text color for primary status.}

\item{primary_border}{Border color for primary status.}

\item{primary_heading_bg}{Heading background color for primary status.}

\item{success_text}{Text color for success status.}

\item{success_border}{Border color for success status.}

\item{success_heading_bg}{Heading background color for success status.}

\item{info_text}{Text color for info status.}

\item{info_border}{Border color for info status.}

\item{info_heading_bg}{Heading background color for info status.}

\item{warning_text}{Text color for warning status.}

\item{warning_border}{Border color for warning status.}

\item{warning_heading_bg}{Heading background color for warning status.}

\item{danger_text}{Text color for danger status.}

\item{danger_border}{Border color for danger status.}

\item{danger_heading_bg}{Heading background color for danger status.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 panel (e.g. \code{\link[shinyWidgets:panel]{shinyWidgets::panel}}
 in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_panel(
  border_radius = "15px",
  default_text = "#FFF",
  default_heading_bg = "#3f2d54",
  default_border = "#3f2d54",
  primary_heading_bg = "#1B9E77",
  primary_border = "#1B9E77",
  success_heading_bg = "#D95F02",
  success_border = "#D95F02",
  success_text = "#FFF",
  danger_heading_bg = "#7570B3",
  danger_border = "#7570B3",
  danger_text = "#FFF"
)

if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_panel(
          border_radius = "15px",
          default_text = "#FFF",
          default_heading_bg = "#3f2d54",
          default_border = "#3f2d54",
          primary_heading_bg = "#1B9E77",
          primary_border = "#1B9E77",
          success_heading_bg = "#D95F02",
          success_border = "#D95F02",
          success_text = "#FFF",
          danger_heading_bg = "#7570B3",
          danger_border = "#7570B3",
          danger_text = "#FFF"
        ),
        output_file = NULL
      )
    ),
    tags$h1("Custom panels"),
    fluidRow(
      column(
        width = 3,
        panel(
          heading = "Default panel",
          "Some content"
        )
      ),
      column(
        width = 3,
        panel(
          heading = "Primary panel",
          status = "primary",
          "Some content"
        )
      ),
      column(
        width = 3,
        panel(
          heading = "Success panel",
          status = "success",
          "Some content"
        )
      ),
      column(
        width = 3,
        panel(
          heading = "Danger panel",
          status = "danger",
          "Some content"
        )
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
