% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.trivPenalNL.R
\name{summary.trivPenalNL}
\alias{summary.trivPenalNL}
\alias{print.summary.trivPenalNL}
\title{Short summary of fixed covariates estimates of a non-linear trivariate joint
model for longitudinal data, recurrent events and a terminal event}
\usage{
\method{summary}{trivPenalNL}(object, level = 0.95, len = 6, d = 2,
lab=c("coef","hr"), ...)
}
\arguments{
\item{object}{an object inheriting from \code{trivPenal} class}

\item{level}{significance level of confidence interval. Default is 95\%.}

\item{len}{the total field width for the terminal part. Default is 6.}

\item{d}{the desired number of digits after the decimal point. Default of 6
digits is used.}

\item{lab}{labels of printed results for the longitudinal outcome and the
terminal event respectively.}

\item{\dots}{other unused arguments.}
}
\value{
For the longitudinal outcome it prints the estimates of coefficients
of the fixed covariates with their standard error and p-values of the Wald
test (separetely for the biomarker growth and decline).  For the terminal
event it prints HR and its confidence intervals for each covariate.
Confidence level is allowed (level argument).
}
\description{
This function returns coefficients estimates and their standard error with
p-values of the Wald test for the biomarker growth (KG) and decline (KD) and
hazard ratios and their confidence intervals for the terminal event.
}
\examples{


\donttest{

###--- Trivariate joint model for longitudinal data, ---###
###--- recurrent events and a terminal event ---###

data(colorectal)
data(colorectalLongi)

# Weibull baseline hazard function
# Random effects as the link function, Gap timescale
# (computation takes around 30 minutes)
model.weib.RE.gap <-trivPenal(Surv(gap.time, new.lesions) ~ cluster(id)
+ age + treatment + who.PS + prev.resection + terminal(state),
formula.terminalEvent =~ age + treatment + who.PS + prev.resection, 
tumor.size ~ year * treatment + age + who.PS, data = colorectal,
data.Longi = colorectalLongi, random = c("1", "year"), id = "id", 
link = "Random-effects", left.censoring = -3.33, recurrentAG = FALSE,
hazard = "Weibull", method.GH="Pseudo-adaptive", n.nodes = 7)

summary(model.weib.RE.gap)
}


}
\seealso{
\code{\link{trivPenalNL}}
}
\keyword{methods}
