% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trivPenal.R
\name{trivPenal}
\alias{trivPenal}
\title{Fit a Trivariate Joint Model for Longitudinal Data, Recurrent Events and a
Terminal Event}
\usage{
trivPenal(formula, formula.terminalEvent, formula.LongitudinalData, data,
data.Longi, random, id, intercept = TRUE, link = "Random-effects",
left.censoring = FALSE, recurrentAG = FALSE, n.knots, kappa, maxit = 300,
hazard = "Splines", init.B, init.Random, init.Eta, init.Alpha, method.GH =
"Standard", n.nodes, LIMparam = 1e-3, LIMlogl = 1e-3, LIMderiv = 1e-3,
print.times = TRUE)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a
\eqn{\sim} operator, and the terms on the right. The response must be a
survival object as returned by the 'Surv' function like in survival package.
Interactions are possible using * or :.}

\item{formula.terminalEvent}{A formula object, only requires terms on the
right to indicate which variables are modelling the terminal event.
Interactions are possible using * or :.}

\item{formula.LongitudinalData}{A formula object, only requires terms on the
right to indicate which variables are modelling the longitudinal outcome. It
must follow the standard form used for linear mixed-effects models.
Interactions are possible using * or :.}

\item{data}{A 'data.frame' with the variables used in \code{formula}.}

\item{data.Longi}{A 'data.frame' with the variables used in
\code{formula.LongitudinalData}.}

\item{random}{Names of variables for the random effects of the longitudinal
outcome. Maximum 3 random effects are possible at the moment. The random
intercept is chosen using \code{"1"}.}

\item{id}{Name of the variable representing the individuals.}

\item{intercept}{Logical value. Is the fixed intercept of the biomarker
included in the mixed-effects model? The default is \code{TRUE}.}

\item{link}{Type of link functions for the dependence between the biomarker
and death and between the biomarker and the recurrent events:
\code{"Random-effects"} for the association directly via the random effects
of the biomarker, \code{"Current-level"} for the association via the true
current level of the biomarker. The option \code{"Current-level"} can be
chosen only if the biomarker random effects are associated with the
intercept and time (following this order). The default is
\code{"Random-effects"}.}

\item{left.censoring}{Is the biomarker left-censored below a threshold
\eqn{s}? If there is no left-censoring, the argument must be equal to
\code{FALSE}, otherwise the value of the threshold must be given.}

\item{recurrentAG}{Logical value.  Is Andersen-Gill model fitted?  If so
indicates that recurrent event times with the counting process approach of
Andersen and Gill is used. This formulation can be used for dealing with
time-dependent covariates.  The default is FALSE.}

\item{n.knots}{Integer giving the number of knots to use. Value required in
the penalized likelihood estimation.  It corresponds to the (n.knots+2)
splines functions for the approximation of the hazard or the survival
functions.  We estimate I or M-splines of order 4. When the user set a
number of knots equals to k (n.knots=k) then the number of interior knots is
(k-2) and the number of splines is (k-2)+order.  Number of knots must be
between 4 and 20. (See Note in \code{frailtyPenal} function)}

\item{kappa}{Positive smoothing parameters in the penalized likelihood
estimation.  The coefficient kappa of the integral of the squared second
derivative of hazard function in the fit (penalized log likelihood). To
obtain an initial value for \code{kappa}, a solution is to fit the
corresponding Cox model using cross validation (See \code{cross.validation}
in function \code{frailtyPenal}).  We advise the user to identify several
possible tuning parameters, note their defaults and look at the sensitivity
of the results to varying them.}

\item{maxit}{Maximum number of iterations for the Marquardt algorithm.
Default is 300}

\item{hazard}{Type of hazard functions: \code{"Splines"} for semiparametric
hazard functions using equidistant intervals or \code{"Splines-per"} using
percentile with the penalized likelihood estimation, \code{"Weibull"} for
the parametric Weibull functions. The default is \code{"Splines"}.}

\item{init.B}{Vector of initial values for regression coefficients. This
vector should be of the same size as the whole vector of covariates with the
first elements for the covariates related to the recurrent events, then to
the terminal event and then to the biomarker (interactions in the end of
each component). Default is 0.5 for each.}

\item{init.Random}{Initial value for variance of the elements of the matrix
of the distribution of the random effects.}

\item{init.Eta}{Initial values for regression coefficients for the link
functions, first for the recurrent events (\eqn{\bold{\eta}_R}) and for the
terminal event (\eqn{\bold{\eta}_T}).}

\item{init.Alpha}{Initial value for parameter alpha}

\item{method.GH}{Method for the Gauss-Hermite quadrature: \code{"Standard"}
for the standard non-adaptive Gaussian quadrature, \code{"Pseudo-adaptive"}
for the pseudo-adaptive Gaussian quadrature and \code{"HRMSYM"} for the
algorithm for the multivariate non-adaptive Gaussian quadrature (see
Details). The default is \code{"Standard"}.}

\item{n.nodes}{Number of nodes for the Gauss-Hermite quadrature. They can be
chosen amon 5, 7, 9, 12, 15, 20 and 32. The default is 9.}

\item{LIMparam}{Convergence threshold of the Marquardt algorithm for the
parameters (see Details), \eqn{10^{-3}} by default.}

\item{LIMlogl}{Convergence threshold of the Marquardt algorithm for the
log-likelihood (see Details), \eqn{10^{-3}} by default.}

\item{LIMderiv}{Convergence threshold of the Marquardt algorithm for the
gradient (see Details), \eqn{10^{-3}} by default.}

\item{print.times}{a logical parameter to print iteration process. Default
is TRUE.}
}
\value{
The following components are included in a 'trivPenal' object for each
model:

\item{b}{The sequence of the corresponding estimation of the coefficients
for the hazard functions (parametric or semiparametric), the random effects
variances and the regression coefficients.} \item{call}{The code used for
the model.} \item{formula}{The formula part of the code used for the
recurrent event part of the model.} \item{formula.terminalEvent}{The formula
part of the code used for the terminal event part of the model.}
\item{formula.LongitudinalData}{The formula part of the code used for the
longitudinal part of the model.} \item{coef}{The regression coefficients
(first for the recurrent events, then for the terminal event and then for
the biomarker.} \item{groups}{The number of groups used in the fit.}
\item{kappa}{The values of the smoothing parameters in the penalized
likelihood estimation corresponding to the baseline hazard functions for the
recurrent and terminal events.} \item{logLikPenal}{The complete marginal
penalized log-likelihood in the semiparametric case.} \item{logLik}{The
marginal log-likelihood in the parametric case.} \item{n.measurements}{The
number of biomarker observations used in the fit.} \item{max_rep}{The
maximal number of repeated measurements per individual.} \item{n}{The number
of observations in 'data' (recurrent and terminal events) used in the fit.}
\item{n.events}{The number of recurrent events observed in the fit.}
\item{n.deaths}{The number of terminal events observed in the fit.}
\item{n.iter}{The number of iterations needed to converge.}
\item{n.knots}{The number of knots for estimating the baseline hazard
function in the penalized likelihood estimation.} \item{n.strat}{The number
of stratum.}

\item{varH}{The variance matrix of all parameters (before positivity
constraint transformation for the variance of the measurement error, for
which the delta method is used).} \item{varHIH}{The robust estimation of the
variance matrix of all parameters.}

\item{xR}{The vector of times where both survival and hazard function of the
recurrent events are estimated. By default seq(0,max(time),length=99), where
time is the vector of survival times.} \item{lamR}{The array (dim=3) of
baseline hazard estimates and confidence bands (recurrent events).}
\item{survR}{The array (dim=3) of baseline survival estimates and confidence
bands (recurrent events).}

\item{xD}{The vector of times where both survival and hazard function of the
terminal event are estimated. By default seq(0,max(time),length=99), where
time is the vector of survival times.} \item{lamD}{The array (dim=3) of
baseline hazard estimates and confidence bands.} \item{survD}{The array
(dim=3) of baseline survival estimates and confidence bands.}
\item{typeof}{The type of the baseline hazard function (0:"Splines",
"2:Weibull").} \item{npar}{The number of parameters.} \item{nvar}{The vector
of number of explanatory variables for the recurrent events, terminal event
and biomarker.} \item{nvarRec}{The number of explanatory variables for the
recurrent events.} \item{nvarEnd}{The number of explanatory variables for
the terminal event.} \item{nvarY}{The number of explanatory variables for
the biomarker.} \item{noVarRec}{The indicator of absence of the explanatory
variables for the recurrent events.} \item{noVarEnd}{The indicator of
absence of the explanatory variables for the terminal event.}
\item{noVarY}{The indicator of absence of the explanatory variables for the
biomarker.} \item{LCV}{The approximated likelihood cross-validation
criterion in the semiparametric case (with H minus the converged Hessian
matrix, and l(.) the full
log-likelihood).\deqn{LCV=\frac{1}{n}(trace(H^{-1}_{pl}H) - l(.))}}
\item{AIC}{The Akaike information Criterion for the parametric
case.\deqn{AIC=\frac{1}{n}(np - l(.))}} \item{n.knots.temp}{The initial
value for the number of knots.} \item{shape.weib}{The shape parameter for
the Weibull hazard functions (the first element for the recurrences and the
second one for the terminal event).} \item{scale.weib}{The scale parameter
for the Weibull hazard functions (the first element for the recurrences and
the second one for the terminal event).} \item{martingale.res}{The
martingale residuals related to the recurrences for each individual.}
\item{martingaledeath.res}{The martingale residuals related to the terminal
event for each individual.} \item{conditional.res}{The conditional residuals
for the biomarker (subject-specific):
\eqn{\bold{R}_i^{(m)}=\bold{y}_i-\bold{X}_{Li}^\top\widehat{\bold{\beta}}_L-\bold{Z}_i^\top\widehat{\bold{b}}_i}.}
\item{marginal.res}{The marginal residuals for the biomarker (population
averaged):
\eqn{\bold{R}_i^{(c)}=\bold{y}_i-\bold{X}_{Li}^\top\widehat{\bold{\beta}}_L}.}
\item{marginal_chol.res}{The Cholesky marginal residuals for the biomarker:
\eqn{\bold{R}_i^{(m)}=\widehat{\bold{U}_i^{(m)}}\bold{R}_i^{(m)}}, where
\eqn{\widehat{\bold{U}_i^{(m)}}} is an upper-triangular matrix obtained by
the Cholesky decomposition of the variance matrix
\eqn{\bold{V}_{\bold{R}_i^{(m)}}=\widehat{\bold{V}_i}-\bold{X}_{Li}(\sum_{i=1}^N\bold{X}_{Li}\widehat{\bold{V}_i}^{-1}\bold{X}_{Li})^{-1}\bold{X}_{Li}^\top}.}
\item{conditional_st.res}{The standardized conditional residuals for the
biomarker.} \item{marginal_st.res}{The standardized marginal residuals for
the biomarker.} \item{random.effects.pred}{ The empirical Bayes predictions
of the random effects (ie. using conditional posterior distributions).}
\item{frailty.pred}{The empirical Bayes predictions of the frailty term (ie.
using conditional posterior distributions).} \item{pred.y.marg}{The marginal
predictions of the longitudinal outcome.} \item{pred.y.cond}{The conditional
(given the random effects) predictions of the longitudinal outcome.}
\item{linear.pred}{The linear predictor for the recurrent events part.}
\item{lineardeath.pred}{The linear predictor for the terminal event part.}
\item{global_chisqR}{The vector with values of each multivariate Wald test
for the recurrent part.} \item{dof_chisqR}{The vector with degrees of
freedom for each multivariate Wald test for the recurrent part.}
\item{global_chisq.testR}{The binary variable equals to 0 when no
multivariate Wald is given, 1 otherwise (for the recurrent part).}
\item{p.global_chisqR}{The vector with the p_values for each global
multivariate Wald test for the recurrent part.}

\item{global_chisqT}{The vector with values of each multivariate Wald test
for the terminal part.} \item{dof_chisqT}{The vector with degrees of freedom
for each multivariate Wald test for the terminal part.}
\item{global_chisq.testT}{The binary variable equals to 0 when no
multivariate Wald is given, 1 otherwise (for the terminal part).}
\item{p.global_chisqT}{The vector with the p_values for each global
multivariate Wald test for the terminal part.}

\item{global_chisqY}{The vector with values of each multivariate Wald test
for the longitudinal part.} \item{dof_chisqY}{The vector with degrees of
freedom for each multivariate Wald test for the longitudinal part.}
\item{global_chisq.testY}{The binary variable equals to 0 when no
multivariate Wald is given, 1 otherwise (for the longitudinal part).}
\item{p.global_chisqY}{The vector with the p_values for each global
multivariate Wald test for the longitudinal part.}

\item{names.factorR}{The names of the "as.factor" variables for the
recurrent part.} \item{names.factorT}{The names of the "as.factor" variables
for the terminal part.} \item{names.factorY}{The names of the "as.factor"
variables for the longitudinal part.}

\item{AG}{The logical value. Is Andersen-Gill model fitted? }

\item{intercept}{The logical value. Is the fixed intercept included in the
linear mixed-effects model?} \item{B1}{The variance matrix of the random
effects for the longitudinal outcome.} \item{sigma2}{The variance of the
frailty term (\eqn{\sigma_v}).} \item{alpha}{The coefficient \eqn{\alpha}
associated with the frailty parameter in the terminal hazard function.}
\item{ResidualSE}{The variance of the measurement error.} \item{etaR}{The
regression coefficients for the link function \eqn{g(\cdot)}.}
\item{etaT}{The regression coefficients for the link function
\eqn{h(\cdot)}.} \item{ne_re}{The number of random effects b used in the
fit.} \item{names.re}{The names of variables for the random effects
\eqn{\bold{b}_i}.} \item{link}{The name of the type of the link functions.}

\item{leftCensoring}{The logical value. Is the longitudinal outcome
left-censored?} \item{leftCensoring.threshold}{For the left-censored
biomarker, the value of the left-censoring threshold used for the fit.}
\item{prop.censored}{The fraction of observations subjected to the
left-censoring.}

\item{methodGH}{The Gaussian quadrature method used in the fit.}
\item{n.nodes}{The number of nodes used for the Gaussian quadrature in the
fit.}

\item{alpha_p.value}{p-value of the Wald test for the estimated coefficient
\eqn{\alpha}.} \item{sigma2_p.value}{p-value of the Wald test for the
estimated variance of the frailty term (\eqn{\sigma_v}).}
\item{etaR_p.value}{p-values of the Wald test for the estimated regression
coefficients for the link function \eqn{g(\cdot)}.}
\item{etaT_p.value}{p-values of the Wald test for the estimated regression
coefficients for the link function \eqn{h(\cdot)}.}
\item{beta_p.value}{p-values of the Wald test for the estimated regression
coefficients.}
}
\description{
{
Fit a trivariate joint model for longitudinal data, recurrent events and a
terminal event using a semiparametric penalized likelihood estimation or a
parametric estimation on the hazard functions.

The longitudinal outcomes \eqn{y_i(t_{ik})} (\eqn{k=1,\ldots,n_i},
\eqn{i=1,\ldots,N}) for \eqn{N} subjects are described by a linear mixed
model and the risks of the recurrent and terminal events are represented by
proportional hazard risk models. The joint model is constructed assuming
that the processes are linked via a latent structure (Krol et al. 2015):

\deqn{\left\{ \begin{array}{lc} y_{i}(t_{ik})=\bold{X}_{Li}(t_{ik})^\top
\bold{\beta}_L +\bold{ Z}_i(t_{ik})^\top \bold{b}_i + \epsilon_i(t_{ik}) &
\mbox{(Longitudinal)} \\
r_{ij}(t|\bold{b}_i)=r_0(t)\exp(v_i+\bold{X}_{Rij}(t)\bold{\beta}_R+g(\bold{b}_i,\bold{\beta}_L,\bold{Z}_i(t),\bold{X}_{Li}(t))^\top
\bold{\eta}_R ) & \mbox{(Recurrent)} \\
\lambda_i(t|\bold{b}_i)=\lambda_0(t)\exp(\alpha
v_i+\bold{X}_{Ti}(t)\bold{\beta}_T+h(\bold{b}_i,\bold{\beta}_L,\bold{Z}_i(t),\bold{X}_{Li}(t))^\top
\bold{\eta}_T ) & \mbox{(Terminal)} \\ \end{array} \right. }

where \eqn{\bold{X}_{Li}(t)}, \eqn{\bold{X}_{Rij}(t)} and
\eqn{\bold{X}_{Ti}} are vectors of fixed effects covariates and
\eqn{\bold{\beta}_L}, \eqn{\bold{\beta}_R} and \eqn{\bold{\beta}_T} are the
associated coefficients. Measurements errors \eqn{\epsilon_i(t_{ik})} are
iid normally distributed with mean 0 and variance \eqn{\sigma_{\epsilon}^2}.
The random effects \eqn{\bold{b}_i = (b_{0i},\ldots, b_{qi})^\top\sim
\mathcal{N}(0,\bold{B}_1)} are associated to covariates \eqn{\bold{Z}_i(t)}
and independent from the measurement error. The relationship between the
biomarker and recurrent events is explained via
\eqn{g(\bold{b}_i,\bold{\beta}_L,\bold{Z}_i(t),\bold{X}_{Li}(t))} with
coefficients \eqn{\bold{\eta}_R} and between the biomarker and terminal
event is explained via
\eqn{h(\bold{b}_i,\bold{\beta}_L,\bold{Z}_i(t),\bold{X}_{Li}(t))} with
coefficients \eqn{\bold{\eta}_T}. Two forms of the functions \eqn{g(\cdot)}
and \eqn{h(\cdot)} are available: the random effects \eqn{\bold{b}_i} and
the current biomarker level \eqn{m_i(t)=\bold{X}_{Li}(t_{ik})^\top
\bold{\beta}_L +\bold{ Z}_i(t_{ik})^\top \bold{b}_i}. The frailty term
\eqn{v_i} is gaussian with mean 0 and variance \eqn{\sigma_v}. Together with
\eqn{\bold{b}_i} constitutes the random effects of the model: \deqn{
\bold{u}_i=\left(\begin{array}{c} \bold{b}_{i}\\v_i \\ \end{array}\right)
\sim \mathcal{N}\left(\bold{0}, \left(\begin{array} {cc} \bold{B}_1&\bold{0}
\\ \bold{0} & \sigma_v^{2}\\\end{array}\right)\right), }

We consider that the longitudinal outcome can be a subject to a
quantification limit, i.e. some observations, below a level of detection
\eqn{s} cannot be quantified (left-censoring).
}
}
\details{
{

Typical usage for the joint model
\preformatted{trivPenal(Surv(time,event)~cluster(id) + var1 + var2 +
terminal(death), formula.terminalEvent =~ var1 + var3, biomarker ~
var1+var2, data, data.Longi, ...)}

The method of the Gauss-Hermite quadrature for approximations of the
multidimensional integrals, i.e. length of \code{random} is 2, can be chosen
among the standard, non-adaptive, pseudo-adaptive in which the quadrature
points are transformed using the information from the fitted mixed-effects
model for the biomarker (Rizopoulos 2012) or multivariate non-adaptive
procedure proposed by Genz et al. 1996 and implemented in FORTRAN subroutine
HRMSYM.  The choice of the method is important for estimations. The standard
non-adaptive Gauss-Hermite quadrature (\code{"Standard"}) with a specific
number of points gives accurate results but can be time consuming. The
non-adaptive procedure (\code{"HRMSYM"}) offers advantageous computational
time but in case of datasets in which some individuals have few repeated
observations (biomarker measures or recurrent events), this method may be
moderately unstable.  The pseudo-adaptive quadrature uses transformed
quadrature points to center and scale the integrand by utilizing estimates
of the random effects from an appropriate linear mixed-effects model (this
transformation does not include the frailty in the trivariate model, for
which the standard method is used). This method enables using less
quadrature points while preserving the estimation accuracy and thus lead to
a better computational time.

NOTE. Data frames \code{data} and \code{data.Longi} must be consistent.
Names and types of corresponding covariates must be the same, as well as the
number and identification of individuals.
}
}
\note{
It is recommended to initialize the parameter values using the results
from the reduced models (for example, \code{longiPenal} for the longitudinal
and terminal part and \code{frailtyPenal} for the recurrent part. See
example.
}
\examples{


\dontrun{

###--- Trivariate joint model for longitudinal data, ---###
###--- recurrent events and a terminal event ---###

data(colorectal)
data(colorectalLongi)

# Parameter initialisation for covariates - longitudinal and terminal part

# Survival data preparation - only terminal events 
colorectalSurv <- subset(colorectal, new.lesions == 0)

initial.longi <- longiPenal(Surv(time1, state) ~ age + treatment + who.PS 
+ prev.resection, tumor.size ~  year * treatment + age + who.PS ,
colorectalSurv,	data.Longi = colorectalLongi, random = c("1", "year"),
id = "id", link = "Random-effects", left.censoring = -3.33, 
n.knots = 6, kappa = 2, method.GH="Pseudo-adaptive",
 maxit=40, n.nodes=7)


# Parameter initialisation for covariates - recurrent part
initial.frailty <- frailtyPenal(Surv(time0, time1, new.lesions) ~ cluster(id)
+ age + treatment + who.PS, data = colorectal,
recurrentAG = TRUE, RandDist = "LogN", n.knots = 6, kappa =2)


# Baseline hazard function approximated with splines
# Random effects as the link function, Calendar timescale
# (computation takes around 40 minutes)

model.spli.RE.cal <-trivPenal(Surv(time0, time1, new.lesions) ~ cluster(id)
+ age + treatment + who.PS +  terminal(state),
formula.terminalEvent =~ age + treatment + who.PS + prev.resection, 
tumor.size ~ year * treatment + age + who.PS, data = colorectal, 
data.Longi = colorectalLongi, random = c("1", "year"), id = "id", 
link = "Random-effects", left.censoring = -3.33, recurrentAG = TRUE,
n.knots = 6, kappa=c(0.01, 2), method.GH="Standard", n.nodes = 7,
init.B = c(-0.07, -0.13, -0.16, -0.17, 0.42, #recurrent events covariates
-0.16, -0.14, -0.14, 0.08, 0.86, -0.24, #terminal event covariates
2.93, -0.28, -0.13, 0.17, -0.41, 0.23, 0.97, -0.61)) #biomarker covariates



# Weibull baseline hazard function
# Random effects as the link function, Gap timescale
# (computation takes around 30 minutes)
model.weib.RE.gap <-trivPenal(Surv(gap.time, new.lesions) ~ cluster(id)
+ age + treatment + who.PS + prev.resection + terminal(state),
formula.terminalEvent =~ age + treatment + who.PS + prev.resection, 
tumor.size ~ year * treatment + age + who.PS, data = colorectal,
data.Longi = colorectalLongi, random = c("1", "year"), id = "id", 
link = "Random-effects", left.censoring = -3.33, recurrentAG = FALSE,
hazard = "Weibull", method.GH="Pseudo-adaptive",n.nodes=7)


}


}
\references{
A. Krol, A. Mauguen, Y. Mazroui, A. Laurent, S. Michiels and V. Rondeau
(2017). Tutorial in Joint Modeling and Prediction: A Statistical Software
for Correlated Longitudinal Outcomes, Recurrent Events and a Terminal Event.
\emph{Journal of Statistical Software} \bold{81}(3), 1-52.

A. Krol, L. Ferrer, JP. Pignon, C. Proust-Lima, M. Ducreux, O. Bouche, S.
Michiels, V. Rondeau (2016). Joint Model for Left-Censored Longitudinal
Data, Recurrent Events and Terminal Event: Predictive Abilities of Tumor
Burden for Cancer Evolution with Application to the FFCD 2000-05 Trial.
\emph{Biometrics} \bold{72}(3) 907-16.

D. Rizopoulos (2012). Fast fitting of joint models for longitudinal and
event time data using a pseudo-adaptive Gaussian quadrature rule.
\emph{Computational Statistics and Data Analysis} \bold{56}, 491-501.

A. Genz and B. Keister (1996). Fully symmetric interpolatory rules for
multiple integrals over infinite regions with Gaussian weight. \emph{Journal
of Computational and Applied Mathematics} \bold{71}, 299-309.
}
\seealso{
\code{\link{plot.trivPenal}},\code{\link{print.trivPenal}},\code{\link{summary.trivPenal}}
}
\keyword{models}
