% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_emfrail.R
\name{ggplot_emfrail}
\alias{ggplot_emfrail}
\alias{ggplot_pred}
\alias{ggplot_hr}
\alias{gghist_frail}
\alias{ggplot_frail}
\title{Plot functions for \code{emfrail} objects using \code{ggplot2}}
\usage{
ggplot_pred(object, lp = 0, newdata = NULL, quantity = "cumhaz",
  type = "both", conf_int = "adjusted", ...)

ggplot_hr(object, lp, newdata = NULL, ...)

gghist_frail(object, ...)

ggplot_frail(object, ...)
}
\arguments{
\item{object}{An \code{emfrail} object}

\item{lp}{The value(s) of the linear predictor. For \code{ggplot_pred} this should have length 1 and for \code{ggplot_hr} length 2.}

\item{newdata}{A \code{data.frame} from each each line corresponds to a value of the linear predictor (optional). For \code{ggplot_pred} this should have 1 row and for \code{plot_hr} 2 rows.}

\item{quantity}{One of "cumhaz" (for cumulative hazard) or "survival"}

\item{type}{One of "conditional", "marginal" or "both"}

\item{conf_int}{One of "adjusted", "regular", or "none}

\item{...}{Parameters passed on to plot functions}
}
\value{
An object of class \code{ggplot}
}
\description{
\code{ggplot_pred} plots predicted cumulative hazard or survival curves, marginal and / or conditional, with or without confidence intervals.

\code{ggplot_hr} plots the estimated marginal and conditional hazard ratio between two units with different linear predictor values.

\code{gghist_frail} plots a histogram of the estimated frailties.

\code{ggplot_frail} plots the ordered estimates of the frailties.
}
\details{
These functions exist mostly for conveince. They are in fact simple wrappers that use \code{predict.emfrail} or \code{summary.emfrail} on
\code{object}, extract some quantities of interest, and plot them. In \code{ggplot_frail},
if the object was fitted with a gamma distribution,
then quantiles of the posterior distribution of the random effects are also plotted.
}
\examples{
mod_rec <- emfrail(bladder1, Surv(start, stop, status) ~ treatment + number + cluster(id))
summary(mod_rec)

# cumulative hazard
# Note: this individual has number = 0, which does not exist in the data
ggplot_pred(mod_rec)

# survival, although not very meaningful with recurrent events
\dontrun{
ggplot_pred(mod_rec, quantity = "survival")
}

# For an individual with number == 2
ggplot_pred(mod_rec, newdata = data.frame(treatment = "placebo", number = 2))

# hazard ratio between an individual with 0 and with 2 recurrences at baseline
# the marginal hazard ratio is "pulled" towards 1:

ggplot_hr(mod_rec, newdata = data.frame(treatment = "placebo", number = c(0, 2)))

\dontrun{
# hazard ratio with the stable distribution:
mod_rec_stab <- emfrail(bladder1,
                        Surv(start, stop, status) ~ treatment + number + cluster(id),
                        .distribution = emfrail_distribution(dist = "stable"))

ggplot_hr(mod_rec_stab, newdata = data.frame(treatment = "placebo", number = c(0, 2)))

# histogram of frailty estimates
gghist_frail(mod_rec_stab)

# plot of the frailty estimates
ggplot_frail(mod_rec_stab)
}


}
\seealso{
\code{\link{predict.emfrail}}, \code{\link{summary.emfrail}}, \code{\link{plot_emfrail}}.
}
