% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticfragility.R
\name{logisticfragility}
\alias{logisticfragility}
\title{Logistic fragility function}
\usage{
logisticfragility(formula, data, covariate, niter, conf.level = 0.95,
  progress.bar = FALSE)
}
\arguments{
\item{formula}{Model formula which will be evaluated by glm()}

\item{data}{Dataframe with values for model forma, passed to glm()}

\item{covariate}{Covariate name (string) whose fragility you would like to test}

\item{niter}{Number of iterations of algorithm to run}

\item{conf.level}{Significance level, set by default to 95\%}

\item{progress.bar}{Print a progress bar?}
}
\value{
Returns the fragility index for a single run
}
\description{
Compute the fragility of a coefficient in a logistic regression for dichotomous outcomes. Wrapper function for logisticfragilityinternal
}
\examples{
# Import and format example data
mydata <- read.csv("http://www.ats.ucla.edu/stat/data/binary.csv")
mydata$rank <- factor(mydata$rank)

# Suggest much higher value for niter in practice (1000+)
logisticfragility(admit ~ gre + gpa + rank, data = mydata, covariate="gre", niter=5)

logisticfragility(admit ~ gre + gpa + rank, data = mydata, covariate="all", niter=5,
                 progress.bar = TRUE)

}

