% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSim.R
\name{simpleSim}
\alias{simpleSim}
\title{Unconditional marker simulation}
\usage{
simpleSim(
  x,
  N,
  alleles,
  afreq,
  ids,
  Xchrom = FALSE,
  mutmod = NULL,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{N}{A positive integer: the number of markers to be simulated.}

\item{alleles}{A vector with allele labels.}

\item{afreq}{A numeric vector of allele frequencies. If missing, the alleles
are assumed to be equifrequent.}

\item{ids}{A vector containing ID labels of those pedigree members whose
genotypes should be simulated.}

\item{Xchrom}{A logical: X linked markers or not?}

\item{mutmod}{A list of mutation matrices named 'female' and 'male'.}

\item{seed}{An integer seed for the random number generator (optional).}

\item{verbose}{A logical.}
}
\value{
A \code{ped} object equal to \code{x} except its \code{MARKERS} entry, which
consists of the \code{N} simulated markers.
}
\description{
Unconditional simulation of unlinked markers
}
\details{
Simple genotype simulation, performed by first distributing alleles randomly
to all founders, followed by Mendelian \emph{gene dropping} down throughout the
pedigree (i.e., for each non-founder a random allele is selected from each of
the parents). Finally, genotypes of individuals not included in \code{ids} are
removed.
}
\examples{
x = nuclearPed(1)
simpleSim(x, N = 3, afreq = c(0.5, 0.5))

y = cousinPed(1, child = TRUE)
simpleSim(y, N = 3, alleles = LETTERS[1:10])

}
\seealso{
\code{\link[=markerSim]{markerSim()}}
}
