% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_add_lines.R
\name{fp_add_lines}
\alias{fp_add_lines}
\title{Adds a line to the graph}
\usage{
fp_add_lines(x, ...)
}
\arguments{
\item{x}{The forestplot object}

\item{...}{A set of arguments. Can either be \code{TRUE} or a set of
numbered arguments with \code{\link[grid]{gpar}}. See line section
below for details.}
}
\value{
The foresplot object with the styles
}
\description{
Adds a line to the graph, defaults to horizontal. Lines with prefix \code{v_} will be vertical, no prefix or \code{h_} will be horizontal.
If argument is \code{TRUE} or just empty: A line will be added based upon the \code{is.summary} rows. If the first line is a summary it
will choose the last non-summary row.
}
\details{
If you provide the argument as a number it will add the line to that particular line. 1 corresponds to the
top row and the max row is \code{num_rows + 1}. If the argument is \code{TRUE} it will default to a standard line.
A string will default to the color of that string. If you provide a \link[grid:gpar]{grid::gpar} element it will style
the line according to the \verb{gpar object}. Apart from allowing standard \code{\link[grid]{gpar}} line descriptions,
\code{lty}, \code{lwd}, \code{col}, and more you can also specify \code{gpar(columns = c(1:3, 5))} if you for instance want
the line to skip a column.

If you want to add mix vertical and horizontal lines you can prefix the lines with \code{h_} and \code{v_}, e.g. \code{v_2} for the
second column.
}
\examples{
base_data <- tibble::tibble(mean  = c(0.578, 0.165, 0.246, 0.700, 0.348, 0.139, 1.017),
                            lower = c(0.372, 0.018, 0.072, 0.333, 0.083, 0.016, 0.365),
                            upper = c(0.898, 1.517, 0.833, 1.474, 1.455, 1.209, 2.831),
                            study = c("Auckland", "Block", "Doran", "Gamsu",
                                      "Morrison", "Papageorgiou", "Tauesch"),
                            deaths_steroid = c("36", "1", "4", "14", "3", "1", "8"),
                            deaths_placebo = c("60", "5", "11", "20", "7", "7", "10"),
                            OR = c("0.58", "0.16", "0.25", "0.70", "0.35", "0.14", "1.02"))

base_data |>
  forestplot(labeltext = c(study, deaths_steroid, deaths_placebo, OR),
             clip = c(0.1, 2.5),
             xlog = TRUE) |>
  fp_add_header(study = c("", "Study"),
                deaths_steroid = c("Deaths", "(steroid)"),
                deaths_placebo = c("Deaths", "(placebo)"),
                OR = c("", "OR")) |>
  fp_set_style(box = "royalblue",
               line = "darkblue") |>
  fp_add_lines("steelblue")


base_data |>
  forestplot(labeltext = c(study, deaths_steroid, deaths_placebo, OR),
             clip = c(0.1, 2.5),
             xlog = TRUE) |>
  fp_add_header(study = c("", "Study"),
                deaths_steroid = c("Deaths", "(steroid)"),
                deaths_placebo = c("Deaths", "(placebo)"),
                OR = c("", "OR")) |>
  fp_set_style(box = "royalblue",
               line = "darkblue") |>
  # Add top line
  fp_add_lines(h_3 = "darkred") |>
  # Add surrounding box with fancy syntax
  fp_add_lines(h_5 = gpar(col = "steelblue", columns = 1:4, lty = 2),
               h_7 = gpar(col = "steelblue", columns = 1:4, lty = 2),
               v_1 = gpar(col = "steelblue", rows = 5:6, lty = 3, lty = 2),
               v_5 = gpar(col = "steelblue", rows = 5:6, lty = 3, lty = 2))
}
\seealso{
Other graph modifiers: 
\code{\link{fp_decorate_graph}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()},
\code{\link{fp_set_zebra_style}()}

Other forestplot functions: 
\code{\link{forestplot}()},
\code{\link{fpColors}()},
\code{\link{fpDrawNormalCI}()},
\code{\link{fpLegend}()},
\code{\link{fpShapesGp}()},
\code{\link{fp_decorate_graph}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()},
\code{\link{fp_set_zebra_style}()}
}
\concept{forestplot functions}
\concept{graph modifiers}
