% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_empty_col.R
\name{rm_empty_col}
\alias{rm_empty_col}
\title{Remove empty columns}
\usage{
rm_empty_col(x)
}
\arguments{
\item{x}{A dataframe}
}
\value{
a dataframe.
}
\description{
This function removes columns filled with \code{NA} or \code{0} from a dataframe.
}
\details{
This function is mainly used inside other functions, to remove optional variables
when they are not opted in.
}
\examples{
library(forestmangr)
library(dplyr)
data("exfm15")
head(exfm15)

exfm15 \%>\% 
mutate(emptycol=NA) \%>\% 
rm_empty_col


}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
