% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_STRidER_freqs.R
\name{read_STRidER_xml}
\alias{read_STRidER_xml}
\title{Parse allele frequencies from STRidER database}
\usage{
read_STRidER_xml(xml_file = "https://strider.online/frequencies/xml")
}
\arguments{
\item{xml_file}{Path to XML file. Default is \code{"https://strider.online/frequencies/xml"}}
}
\value{
A named list by population. Each population is a list of loci with
        named numeric vectors of allele frequencies. Each vector has an
        attribute \code{N} for sample size (number of alleles observed).
}
\description{
Parse allele frequencies from STRidER database
}
\references{
Bodner M. et al. (2016), 'Recommendations of the DNA Commission
of the International Society for Forensic Genetics (ISFG) on quality control
 of autosomal Short Tandem Repeat allele frequency databasing (STRidER).',
 Forensic Sci. Int. Genet. 24, 97-102.
 \doi{10.1016/j.fsigen.2016.06.008}

 @importFrom xml2 read_xml xml_find_all xml_text xml_find_first xml_attr
 @importFrom stats setNames

 @examplesIf interactive()
 # Import STRidER database
 freqs <- read_STRidER_xml()

 # Origins
 names(freqs)

 # Access frequencies at the TH01 locus for the NORWAY origin
 freqs$NORWAY$TH01
}
