% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{identity_rewrite_callback}
\alias{identity_rewrite_callback}
\alias{identity_analysis_callback}
\title{A callback that does not do any transformation.}
\usage{
identity_rewrite_callback(expr, ...)

identity_analysis_callback(expr, bottomup, ...)
}
\arguments{
\item{expr}{The expression to (not) transform.}

\item{...}{Additional named parameters.}

\item{bottomup}{Information gathered depth-first in analysis callbacks. This
parameter is only passed to callbacks in analysis traversals and not
rewrite traversals.}
}
\value{
\code{expr}
}
\description{
Callbacks have one required argument, \code{expr}, but will actually be called
with more. The additional named parameters are:
}
\details{
\itemize{
\item \strong{env}      The function environment of the function we are transforming
\item \strong{params}   The formal parameters of the function we are transforming
\item \strong{topdown}  Data passed top-down in the traversal.
\item \strong{bottomup} Data collected by depth-first traversals before a callback is
called. plus whatever the user provide to \code{\link[=depth_first_rewrite_function]{depth_first_rewrite_function()}} or
\code{\link[=depth_first_analyse_function]{depth_first_analyse_function()}}.
\item \strong{next_cb} A handle to call the next callback if more are installed. This
variable will be the callback that was in the callbacks list before this one
replaced it.
}

In bottom up analyses, the \code{\link[=merge_bottomup]{merge_bottomup()}} function can be used to
collected the results of several recursive calls. When annotating
expressions, the \code{\link[=collect_from_args]{collect_from_args()}} can be used in \code{call} callbacks to
extract annotation information from call arguments.
}
\section{Functions}{
\itemize{
\item \code{identity_rewrite_callback}: Identity for expression rewriting

\item \code{identity_analysis_callback}: Identity for expression rewriting
}}

\seealso{
merge_bottomup

collect_from_args
}
