% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idio.R
\name{print.threshold}
\alias{print.threshold}
\title{Print threshold}
\usage{
\method{print}{threshold}(x, ...)
}
\arguments{
\item{x}{\code{threshold} object}

\item{...}{not used}
}
\value{
NULL, printed to console
}
\description{
Prints a summary of a \code{threshold} object
}
\examples{
\dontrun{
library(fnets)

set.seed(123)
n <- 500
p <- 20
common <- sim.unrestricted(n, p)
idio <- sim.var(n, p)
x <- common$data + idio$data
out <- fnets(x,
   var.args = list(n.cores = 2)
)
# Granger-causal network
th1 <- threshold(out$idio.var$beta)
plot(th1)
print(th1)
# Partial correlations
th2 <- threshold(out$lrpc$pc)
# Long-run partial correlations
th3 <- threshold(out$lrpc$lrpc)
}
}
\references{
Barigozzi, M., Cho, H. & Owens, D. (2022) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. arXiv preprint arXiv:2201.06110.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling
}
\seealso{
\link[fnets]{threshold}
}
