% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcat.R
\name{print.fcat}
\alias{print.fcat}
\title{Print a format catalog}
\usage{
\method{print}{fcat}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The format catalog to print.}

\item{...}{Any follow-on parameters.}

\item{verbose}{Whether or not to print the format catalog in verbose style.
By default, the parameter is FALSE, meaning to print in tabular style.}
}
\value{
The object, invisibly.
}
\description{
A class-specific instance of the \code{print} function for 
format catalogs.  The function prints the format catalog in a tabular manner.  
Use \code{verbose = TRUE} to print the catalog as a list.
}
\examples{
#' # Create format catalog
c1 <- fcat(num_fmt  = "\%.1f",
           label_fmt = value(condition(x == "A", "Label A"),
                             condition(x == "B", "Label B"),
                             condition(TRUE, "Other")),
           date_fmt = "\%d\%b\%Y")
           
# Print the catalog
print(c1)
# # A format catalog: 3 formats
# - $num_fmt: type S, "\%.1f"
# - $label_fmt: type U, 3 conditions
# - $date_fmt: type S, "\%d\%b\%Y"
}
\seealso{
Other fcat: 
\code{\link{as.data.frame.fcat}()},
\code{\link{as.fcat.data.frame}()},
\code{\link{as.fcat.fmt_lst}()},
\code{\link{as.fcat.list}()},
\code{\link{as.fcat}()},
\code{\link{fcat}()},
\code{\link{is.fcat}()},
\code{\link{read.fcat}()},
\code{\link{write.fcat}()}
}
\concept{fcat}
