% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/crs.R, R/mesh.R, R/sp_mesh.R
\name{fmesher-deprecated}
\alias{fmesher-deprecated}
\alias{fm_spTransform}
\alias{fm_spTransform.default}
\alias{fm_spTransform.SpatialPoints}
\alias{fm_spTransform.SpatialPointsDataFrame}
\alias{fm_spTransform.inla.mesh.lattice}
\alias{fm_spTransform.inla.mesh.segment}
\alias{fm_spTransform.inla.mesh}
\alias{fm_has_PROJ6}
\alias{fm_not_for_PROJ6}
\alias{fm_not_for_PROJ4}
\alias{fm_fallback_PROJ6}
\alias{fm_requires_PROJ6}
\alias{fm_as_sp_crs}
\alias{fm_sp_get_crs}
\alias{fm_as_inla_mesh_segment}
\alias{fm_as_inla_mesh}
\alias{fm_sp2segment}
\title{Deprecated functions in fmesher}
\usage{
fm_spTransform(x, ...)

\method{fm_spTransform}{default}(x, crs0 = NULL, crs1 = NULL, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPoints}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{SpatialPointsDataFrame}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh.lattice}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh.segment}(x, CRSobj, passthrough = FALSE, ...)

\method{fm_spTransform}{inla.mesh}(x, CRSobj, passthrough = FALSE, ...)

fm_has_PROJ6()

fm_not_for_PROJ6(fun = NULL)

fm_not_for_PROJ4(fun = NULL)

fm_fallback_PROJ6(fun = NULL)

fm_requires_PROJ6(fun = NULL)

fm_as_sp_crs(x, ...)

fm_sp_get_crs(x)

fm_as_inla_mesh_segment(...)

fm_as_inla_mesh(...)

fm_sp2segment(...)
}
\arguments{
\item{x}{A \code{sp::Spatial} object}

\item{\dots}{Potential additional arguments}

\item{crs0}{The source sp::CRS or inla.CRS object}

\item{crs1}{The target sp::CRS or inla.CRS object}

\item{passthrough}{Default is FALSE.
Setting to TRUE allows objects with no CRS information to be passed
through without transformation.}

\item{CRSobj}{The target sp::CRS or inla.CRS object}

\item{fun}{The name of the function that requires PROJ6. Default: NULL,
which uses the name of the calling function.}
}
\value{
A \code{CRS} object, or NULL if no valid CRS identified

An \code{fm_segm} object

An \code{fm_mesh_2d} object
}
\description{
These functions still attempt to do their job, but will be removed in a
future version.
}
\details{
This function is a convenience method to workaround PROJ4/PROJ6
differences, and the lack of a crs extraction method for Spatial objects.
For newer code, use \code{\link[=fm_crs]{fm_crs()}} instead, that returns \code{crs} objects,
and use \link[=fm_crs]{fm_CRS()} to extract/construct/convert to old style \code{sp::CRS} objects.
}
\section{Functions}{
\itemize{
\item \code{fm_spTransform()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} (See \code{\link[=fm_transform]{fm_transform()}} instead)
Handle transformation of various inla objects according to coordinate
reference systems of \code{sp::CRS} or \code{INLA::inla.CRS} class.

\item \code{fm_spTransform(default)}: The default method handles low level transformation of raw
coordinates.

\item \code{fm_has_PROJ6()}: Detect whether PROJ6 is available

\item \code{fm_not_for_PROJ6()}: \code{fm_not_for_PROJ6} is called to warn about using old PROJ4
features even though PROJ6 is available

\item \code{fm_not_for_PROJ4()}: \code{fm_not_for_PROJ4} is called to give an error when
calling methods that are only available for PROJ6

\item \code{fm_fallback_PROJ6()}: Called to warn about falling back
to using old PROJ4 methods when a PROJ6 method hasn't been implemented

\item \code{fm_requires_PROJ6()}: Called to give an error when PROJ6
is required but not available

\item \code{fm_as_sp_crs()}: Wrapper for \code{\link[=fm_CRS]{fm_CRS()}}
\code{sp::Spatial} and \code{sp::CRS} objects.

\item \code{fm_sp_get_crs()}: Wrapper for CRS(projargs) (PROJ4) and CRS(wkt) for
\code{sp::Spatial} objects.

\item \code{fm_as_inla_mesh_segment()}: Conversion to inla.mesh.segment
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of \code{\link[=fm_as_segm]{fm_as_segm()}}.

\item \code{fm_as_inla_mesh()}: Conversion to inla.mesh.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of \code{\link[=fm_as_mesh_2d]{fm_as_mesh_2d()}}.

\item \code{fm_sp2segment()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} in favour of
\code{\link[=fm_as_segm]{fm_as_segm()}}

}}
\examples{
if (fm_safe_sp()) {
  s <- sp::SpatialPoints(matrix(1:6, 3, 2), proj4string = fm_CRS("sphere"))
  fm_CRS(s)
}
}
\seealso{
\code{\link[=fm_transform]{fm_transform()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
