% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{flow_distance}
\alias{flow_distance}
\title{Calculate Flow Distance and Dissimilarity}
\usage{
flow_distance(x, alpha = 1, beta = 1)
}
\arguments{
\item{x}{tibble with flow_ID, x, y, u, v, length_m}

\item{alpha}{numeric, origin weight}

\item{beta}{numeric, destination weight}
}
\value{
tibble of all OD pairs with fd, fds columns
}
\description{
This function calculates flow distance and dissimilarity measures between all
pairs of flows based on the method described in @tao2016spatial.
}
\examples{
flows <- sf::st_transform(flows_leeds, 3857)
flows <- head(flows, 100) # for testing
# Add flow lengths and coordinates
flows <- add_flow_length(flows)
flows <- add_xyuv(flows)
# Calculate distances
distances <- flow_distance(flows, alpha = 1.5, beta = 0.5)
}
\references{
Tao, R., Thill, J.-C., 2016. Spatial cluster detection in spatial flow data. Geographical
Analysis 48, 355–372. https://doi.org/10.1111/gean.12100
}
