% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_fc.R
\name{as_fc}
\alias{as_fc}
\title{as_fc}
\usage{
as_fc(
  .data = NULL,
  N = NULL,
  label = "Initial dataframe",
  text_pattern = "{label}\\n{N}",
  just = "center",
  text_color = "black",
  text_fs = 8,
  text_fface = 1,
  text_ffamily = NA,
  text_padding = 1,
  bg_fill = "white",
  border_color = "black",
  hide = FALSE
)
}
\arguments{
\item{.data}{Data frame to be initialised as a flowchart.}

\item{N}{Number of rows of the study in case `.data` is NULL.}

\item{label}{Character or expression with the text that will be shown in the box.}

\item{text_pattern}{Structure that will have the text in the box. It recognizes label, n, N and perc within brackets. By default it is "\{label\}\\n\{N\}". If label is an expression, the label is always placed at the beginning of the pattern, followed by a line break where the structure specified by text_pattern is placed.}

\item{just}{Justification for the text: left, center or right. Default is center.}

\item{text_color}{Color of the text. It is black by default. See the `col` parameter for \code{\link{gpar}}.}

\item{text_fs}{Font size of the text. It is 8 by default. See the `fontsize` parameter for \code{\link{gpar}}.}

\item{text_fface}{Font face of the text. It is 1 by default. See the `fontface` parameter for \code{\link{gpar}}.}

\item{text_ffamily}{Changes the font family of the text. Default is NA. See the `fontfamily` parameter for \code{\link{gpar}}.}

\item{text_padding}{Changes the text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill}{Box background color. It is white by default. See the `fill` parameter for \code{\link{gpar}}.}

\item{border_color}{Box border color. It is black by default. See the `col` parameter for \code{\link{gpar}}.}

\item{hide}{Logical value to hide the initial box or not. Default is FALSE. hide = TRUE can only be combined with fc_split().}
}
\value{
List with the dataset and the initialized flowchart parameters.
}
\description{
This function allows to initialize a flow chart given any database. It will create a fc object showing the number of rows of the database. If a database is not available, the user can instead directly enter the number of rows in the study.
}
\examples{
safo |>
as_fc(label = "Patients assessed for eligibility") |>
fc_draw()

}
