% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.r
\docType{methods}
\name{converters}
\alias{converters}
\alias{fl}
\alias{dbl}
\alias{int}
\alias{as.float}
\alias{as.double.float32}
\alias{as.integer.float32}
\alias{as.numeric,float32-method}
\alias{as.vector.float32}
\alias{as.matrix.float32}
\alias{typeof,float32-method}
\alias{storage.mode,float32-method}
\title{converters}
\usage{
fl(x, strict = FALSE)

dbl(x, strict = FALSE)

int(x, strict = FALSE)

as.float(x, strict = FALSE)

\method{as.double}{float32}(x, ...)

\method{as.integer}{float32}(x, ...)

\S4method{as.numeric}{float32}(x, ...)

\method{as.vector}{float32}(x, mode = "any")

\method{as.matrix}{float32}(x, ...)

\S4method{typeof}{float32}(x)

\S4method{storage.mode}{float32}(x)
}
\arguments{
\item{x}{A numeric or float vector/matrix.}

\item{strict}{Should the function error if given the wrong kind of input? Otherwise it just
silently returns the input.}

\item{mode, ...}{Ignored.}
}
\value{
The data stored in the type of whatever was asked for (the opposite of the
input).
}
\description{
Convert between a numeric vector/matrix and a float vector/matrix.
}
\details{
\code{fl()}, \code{int()}, and \code{dbl()} are shorthand for
\code{as.float()}, \code{as.integer()}, and \code{as.double()}, respectively.
}
\examples{
library(float)

x = matrix(1:30, 10, 3)
s = fl(x)

y = dbl(s)

all.equal(x, y)

}
