% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstate.R
\name{pfinal_fmsm}
\alias{pfinal_fmsm}
\title{Probabilities of final states in a flexible parametric competing risks model}
\usage{
pfinal_fmsm(x, newdata = NULL, fromstate, maxt = 1e+05, B = 0, cores = NULL)
}
\arguments{
\item{x}{Object returned by \code{\link{fmsm}}, representing a multi-state
model formed from transition-specific time-to-event models fitted by
\code{\link{flexsurvreg}}.}

\item{newdata}{Data frame of covariate values, with one column per
covariate, and one row per alternative value.}

\item{fromstate}{State from which to calculate the transition probability
state.  This should refer to the name of a row of the transition matrix
\code{attr(x,trans)}.}

\item{maxt}{Large time to use for forecasting final state probabilities.
The transition probability from zero to this time is used.  Note
\code{Inf} will not work. The default is \code{100000}.}

\item{B}{Number of simulations to use to calculate 95\% confidence intervals
based on the asymptotic normal distribution of the basic parameter
estimates. If \code{B=0} then no intervals are calculated.}

\item{cores}{Number of processor cores to use.  If \code{NULL} (the default)
then a single core is used.}
}
\value{
A data frame with one row per covariate value and destination state,
  giving the state in column \code{state}, and probability in column
  \code{val}. Additional columns \code{lower} and \code{upper} for the
  confidence limits are returned if \code{B=0}.
}
\description{
This requires the model to be Markov, and is not valid for semi-Markov
models, as it works by wrapping \code{\link{pmatrix.fs}} to calculate the
transition probability over a very large time.    As it also works on a
\code{fmsm} object formed from transition-specific time-to-event models,
it therefore only works on competing risks models, defined by just one starting
state with multiple destination states representing competing events. 
For these models, this function returns the probability governing which
competing event happens next.   However this function simply wraps \code{pmatrix.fs},
so for other models, \code{pmatrix.fs} or \code{pmatrix.simfs} can be used with a
large forecast time \code{t}.
}
