% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-update-news.R
\name{update_news}
\alias{update_news}
\title{Update NEWS.md with messages from top-level commits}
\usage{
update_news(messages = NULL)
}
\arguments{
\item{messages}{A character vector of commit messages,
e.g. as in the \code{message} column in the return value of \code{\link[=get_top_level_commits]{get_top_level_commits()}}.
The default uses the top level commits since the last tag as retrieved by \code{\link[=get_last_tag]{get_last_tag()}}.}
}
\value{
None
}
\description{
Lists all commits from a range (default: top-level commits since the most
recent tag) and adds bullets from their body to \code{NEWS.md}.
Creates \code{NEWS.md} if necessary.
}
\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
  fledge::update_news(c("- something I forgot", "- blabla"))
  fledge::update_version()
  gert::git_add("NEWS.md")
  gert::git_commit(message = "release notes tweaking")
  fledge::tag_version()
  print(fledge::get_last_tag())
})
}
