% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\docType{package}
\name{flatxml}
\alias{flatxml}
\alias{flatxml-package}
\title{flatXML: Tools for Working with XML Files as R Dataframes}
\description{
flatXML: Tools for Working with XML Files as R Dataframes
}
\section{Overview}{

\code{flatxml} provides functions to easily deal with XML files. When parsing an XML document with \code{\link{fxml_importXMLFlat}}, \code{flatxml} produces a special dataframe that is \'flat\' by its very nature but contains all necessary information about the hierarchical structure of the underlying XML document (for details on the dataframe see the reference for the \code{\link{fxml_importXMLFlat}} function).
\code{flatxml} offers a set of functions to work with this dataframe.
Apart from representing the XML document in a dataframe structure, there is yet another way in which \code{flatxml} relates to dataframes: the \code{\link{fxml_toDataFrame}} function can be used to extract data from an XML document into a dataframe, e.g. to work on the data with statistical functions. Because in this case there is no need to represent the XML document structure as such (it's all about the data contained in the document), there is no representation of the hierarchical structure of the document any more, it's just a normal dataframe.
Each XML element, for example \code{<tag attribute="some value">Here is some text</tag>} has certain characteristics that can be accessed via the \code{flatxml} interface functions, after an XML document has been imported with \code{\link{fxml_importXMLFlat}}. These characteristics are:
\itemize{
\item \emph{value}: The (text) value of the element, \code{"Here is some text"} in the example above
\item \emph{attributes}: The XML attributes of the element, \code{attribute} with its value \code{"some value"} in the example above
\item \emph{children}: The elements on the next lower hierarchical level
\item \emph{parent}: The element of the next higher hierarchical level, i.e. the element to which the current element is a child
\item \emph{siblings}: The elements on the same hierarchical level as the current element
}
}

\section{Structure of the flatxml interface}{

The \code{flatxml} interface to access these characteristics follows a simple logic: For each of the characteristics there are typically three functions available:
\itemize{
\item \code{fxml_has...()}: Determines if the current XML element has (at least one instance of) the characteristic
\item \code{fxml_num...()}: Returns the number of the characteristics of the current XML (e.g. the number of children elements)
\item \code{fxml_get...()}: Returns (the IDs of) the respective characteristics of the current XML element (e.g. the children of the current element)
}
}

\section{Functions to access the characteristics of an XML element}{


For values:
\itemize{
\item \code{\link{fxml_hasValue}}
\item \code{\link{fxml_getValue}}
}
For attributes:
\itemize{
\item \code{\link{fxml_hasAttributes}}
\item \code{\link{fxml_numAttributes}}
\item \code{\link{fxml_getAttribute}} (note: no plural 's'!)
\item \code{\link{fxml_getAttributesAll}} (get all attributes instead of a specific one)
}
For children:
\itemize{
\item \code{\link{fxml_hasChildren}}
\item \code{\link{fxml_numChildren}}
\item \code{\link{fxml_getChildren}}
}
For parents:
\itemize{
\item \code{\link{fxml_hasParent}}
\item \code{\link{fxml_getParent}}
}
For siblings:
\itemize{
\item \code{\link{fxml_hasSiblings}}
\item \code{\link{fxml_numSiblings}}
\item \code{\link{fxml_getSiblings}}
}
}

\section{Functions for searching in the XML document}{

\itemize{
\item \code{\link{fxml_findPath}} (search anywhere in the path to an XML element)
\item \code{\link{fxml_findPathFull}} (find an element based on its complete path)
\item \code{\link{fxml_findPathRoot}} (search in the path to an XML element starting at the top element [root node])
\item \code{\link{fxml_findPathBottom}} (search in the path to an XML element starting at the lowest hierarchical level)
}
}

\section{Other functions}{


\itemize{
\item \code{\link{fxml_getElement}} (name on an XML element (the \code{tag} in \code{<tag>…</tag>})
\item \code{\link{fxml_getUniqueElements}} (unique XML elements in the document)
\item \code{\link{fxml_getElementInfo}} (all relevant information on an XML element (children, siblings, etc.)
\item \code{\link{fxml_getDepthLevel}} (level of an element in the hierarchy of the XML document)
}
}

