% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamMixHMM.R
\docType{class}
\name{ParamMixHMM-class}
\alias{ParamMixHMM-class}
\alias{ParamMixHMM}
\title{A Reference Class which contains parameters of a mixture of HMM models.}
\description{
ParamMixHMM contains all the parameters of a mixture of HMM models.
}
\section{Fields}{

\describe{
\item{\code{fData}}{\link{FData} object representing the sample (covariates/inputs
\code{X} and observed responses/outputs \code{Y}).}

\item{\code{K}}{The number of clusters (Number of HMM models).}

\item{\code{R}}{The number of regimes (HMM components) for each cluster.}

\item{\code{variance_type}}{Character indicating if the model is homoskedastic
(\code{variance_type = "homoskedastic"}) or heteroskedastic (\code{variance_type = "heteroskedastic"}). By default the model is heteroskedastic.}

\item{\code{order_constraint}}{A logical indicating whether or not a mask of order
one should be applied to the transition matrix of the Markov chain to
provide ordered states. For the purpose of segmentation, it must be set to
\code{TRUE} (which is the default value).}

\item{\code{alpha}}{Cluster weights. Matrix of dimension \eqn{(K, 1)}.}

\item{\code{prior}}{The prior probabilities of the Markov chains. \code{prior} is a
matrix of dimension \eqn{(R, K)}. The k-th column represents the prior
distribution of the Markov chain asociated to the cluster k.}

\item{\code{trans_mat}}{The transition matrices of the Markov chains. \code{trans_mat} is
an array of dimension \eqn{(R, R, K)}.}

\item{\code{mask}}{Mask applied to the transition matrices \code{trans_mat}. By default,
a mask of order one is applied.}

\item{\code{mu}}{Means. Matrix of dimension \eqn{(R, K)}. The k-th column gives
represents the k-th cluster and gives the means for the \code{R} regimes.}

\item{\code{sigma2}}{The variances for the \code{K} clusters. If MixHMM model is
heteroskedastic (\code{variance_type = "heteroskedastic"}) then \code{sigma2} is a
matrix of size \eqn{(R, K)} (otherwise MixHMM model is homoskedastic
(\code{variance_type = "homoskedastic"}) and \code{sigma2} is a matrix of size
\eqn{(1, K)}).}

\item{\code{nu}}{The degrees of freedom of the MixHMM model representing the
complexity of the model.}
}}

\section{Methods}{

\describe{
\item{\code{initGaussParamHmm(Y, k, R, variance_type, try_algo)}}{Initialize the means \code{mu} and \code{sigma2} for the cluster
\code{k}.}

\item{\code{initParam(init_kmeans = TRUE, try_algo = 1)}}{Method to initialize parameters \code{alpha}, \code{prior}, \code{trans_mat},
      \code{mu} and \code{sigma2}.

      If \code{init_kmeans = TRUE} then the curve partition is initialized by
      the K-means algorithm. Otherwise the curve partition is initialized
      randomly.

      If \code{try_algo = 1} then \code{mu} and \code{sigma2} are
      initialized by segmenting  the time series \code{Y} uniformly into
      \code{R} contiguous segments. Otherwise, \code{mu} and
      \code{sigma2} are initialized by segmenting randomly the time series
      \code{Y} into \code{R} segments.}

\item{\code{MStep(statMixHMM)}}{Method which implements the M-step of the EM algorithm to learn the
parameters of the MixHMM model based on statistics provided by the object
\code{statMixHMM} of class \link{StatMixHMM} (which contains the
E-step).}
}}

