% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{obs2remove}
\alias{obs2remove}
\title{Finds observations to be removed from ML estimation with factors/clusters}
\usage{
obs2remove(fml, data, family = c("poisson", "negbin", "logit"))
}
\arguments{
\item{fml}{A formula containing the dependent variable and the clusters. It can be of the type: \code{y ~ cluster_1 + cluster_2} or \code{y ~ x1 | cluster_1 + cluster_1} (in which case variables before the pipe are ignored).}

\item{data}{A data.frame containing the variables in the formula.}

\item{family}{Character scalar: either \dQuote{poisson} (default), \dQuote{negbin} or \dQuote{logit}.}
}
\value{
It returns an integer vector of observations to be removed. If no observations are to be removed, an empty integer vector is returned. In both cases, it is of class \code{fixest.obs2remove}.
The vector has an attribute \code{cluster} which is a list giving the IDs of the clusters that have been removed, for each cluster dimension.
}
\description{
For Poisson, Negative Binomial or Logit estimations with fixed-effects, when the dependent variable is only equal to 0 (or 1 for Logit) for one cluster value this leads to a perfect fit for that cluster value by setting its associated cluster coefficient to \code{-Inf}. Thus these observations need to be removed before estimation. This function gives the observations to be removed. Note that by default the function \code{\link[fixest]{femlm}} or \code{\link[fixest]{feglm}} drops them before performing the estimation.
}
\examples{

base = iris
# v6: Petal.Length with only 0 values for 'setosa'
base$v6 = base$Petal.Length
base$v6[base$Species == "setosa"] = 0

(x = obs2remove(v6 ~ Species, base))
attr(x, "cluster")

# The two results are identical:
res_1 = femlm(v6 ~ Petal.Width | Species, base)
# => note + obsRemoved is created

res_2 = femlm(v6 ~ Petal.Width | Species, base[-x, ])
# => no note because observations are removed before

esttable(res_1, res_2)

all(res_1$obsRemoved == x)

}
