% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{exchange_trade_FI_RUS}
\alias{exchange_trade_FI_RUS}
\title{Exchange trade between Finland and Russia}
\usage{
exchange_trade_FI_RUS(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains direct trade volumes derive from
freely placed bids in the Nordic day-ahead (Elspot) and intraday
(Elbas) electricity markets. Information is updated once the day-ahead
market results are public. Information on the intraday trade is updated
before the operational hour.
}
\description{
Check https://data.fingrid.fi/en/dataset/stock-exchange-between-finland-and-russia
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- exchange_trade_FI_RUS(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
