% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_types.R
\name{nearest_neighbours}
\alias{nearest_neighbours}
\title{Nearest neighbours}
\usage{
nearest_neighbours(AreaCode, AreaTypeID = 101, measure, path)
}
\arguments{
\item{AreaCode}{Character vector, ONS area code of area of interest}

\item{AreaTypeID}{AreaTypeID of the nearest neighbours (see
\code{\link{area_types}}) for IDs. Only returns information on AreaTypeIDs
101, 102, 201, 202, 152, 153 and 154}

\item{measure}{string; when AreaTypeID = 102 measure must be either "CIPFA"
for CIPFA local authority nearest neighbours or "CSSN" for Children's
services statistical neighbours}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A character vector of area codes
}
\description{
Outputs a character vector of similar areas for given area. Currently returns
similar areas for Clinical Commissioning Groups (old and new) based on
\href{https://www.england.nhs.uk/publication/similar-10-ccg-explorer-tool/}{NHS
England's similar CCG explorer tool} or lower and upper tier local
authorities based on
\href{https://www.cipfastats.net/resources/nearestneighbours/}{CIPFA's
Nearest Neighbours Model} or upper tier local authorities based on
\href{https://www.gov.uk/government/publications/local-authority-interactive-tool-lait}{Children's
services statistical neighbour benchmarking tool}
}
\details{
Use AreaTypeID = 102 for the AreaTypeID related to Children's
  services statistical neighbours
}
\examples{
\dontrun{
nearest_neighbours(AreaCode = "E38000002", AreaTypeID = 154)}
}
\seealso{
\code{\link{indicators}} for indicator lookups,
  \code{\link{profiles}} for profile lookups,
  \code{\link{deprivation_decile}} for deprivation decile lookups,
  \code{\link{area_types}} for area type lookups,
  \code{\link{category_types}} for category type lookups,
  \code{\link{indicators_unique}} for unique indicatorids and their names,
  \code{\link{indicator_areatypes}} for indicators by area types lookups and
  \code{\link{indicator_order}} for the order indicators are presented on the
  Fingertips website within a Domain

Other lookup functions: 
\code{\link{area_types}()},
\code{\link{category_types}()},
\code{\link{deprivation_decile}()},
\code{\link{indicator_areatypes}()},
\code{\link{indicator_metadata}()},
\code{\link{indicator_order}()},
\code{\link{indicators_unique}()},
\code{\link{indicators}()},
\code{\link{profiles}()}
}
\concept{lookup functions}
