% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_pattern.r
\name{scale_fill_pattern}
\alias{scale_fill_pattern}
\title{Patterned Fills for ggplot.}
\usage{
scale_fill_pattern(
  patterns = seq_len,
  fg = NA,
  bg = ifelse(is.na(fg), "transparent", NA),
  fade = ifelse(is.na(fg), 1, 0.6),
  alpha = 1,
  angle = 0,
  width = unit(1/10, "npc"),
  height = NA,
  lwd = 1,
  lty = "solid",
  fun = NULL
)
}
\arguments{
\item{patterns}{A vector of pattern names that will be subset or recycled
as needed to match the levels of the \code{aes()} fill variable. If
integers are provided, they are mapped to predefined patterns.
See "Details and "Pattern Names" sections below. Default: \code{seq_len}}

\item{fg}{Foreground color for the pattern's lines, or \code{NA} to use the
color scale for the \code{aes()} color variable. Default: \code{NA}}

\item{bg}{Background color (or grob), or \code{NA} to use the color scale for
the \code{aes()} color variable.
Default: \code{ifelse(is.na(fg), "transparent", NA)}}

\item{fade, alpha}{Modify the color from the \code{aes()} color scale. Fade will
make it more white, and alpha will make it more transparent. Both
values must be between 0 and 1, inclusive, where 1 means unchanged.
Default: \verb{fade = ifelse(is.na(fg), 1, 0.6), alpha = 1}}

\item{angle}{How much the rotate the pattern, given in degrees clockwise.
Default: \code{0}}

\item{width}{The width of the pattern tile. Assumed to be millimeters
unless set otherwise with \code{\link[=unit]{unit()}}. Default: \code{unit(1/10, 'npc')}}

\item{height}{The height of the pattern tile, or \code{NA} to match \code{width}.
Assumed to be millimeters unless set otherwise with \code{\link[=unit]{unit()}}.
Default: \code{NA}}

\item{lwd}{Line width. A positive number.
See \code{\link[graphics:par]{graphics::par()}} for additional details. Default: \code{1}}

\item{lty}{Line type. One of \code{"solid"}, \code{"dashed"}, \code{"dotted"},
\code{"dotdash"}, \code{"longdash"}, or \code{"twodash"}.
See \code{\link[graphics:par]{graphics::par()}} for additional details. Default: \code{"solid"}}

\item{fun}{A function for modifying graphical parameters immediately
before rendering. Should accept two parameters: \code{env}, an
environment that the function should modify, and \code{row}, the row of
transformed data that ggbuild has constructed for this grob
(including aes mappings). The return value is not used.
Default: \code{NULL}}
}
\value{
A \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}} object.
}
\description{
Patterned Fills for ggplot.
}
\details{
All of the parameters can accept a vector of values or a function
that takes \code{n} as an argument and returns the value(s) to use. The
values are subset or recycled as needed to obtain the same number
as \code{length(levels(fill))}, where fill is the variable defined by
\code{aes(fill = )}.
}
\section{Pattern Names}{


\strong{Base name:}
\itemize{
\item Pattern names must always begin with one of \code{"brick"}, \code{"chevron"},
\code{"fish"}, \code{"grid"}, \code{"herringbone"}, \code{"hexagon"}, \code{"octagon"}, \code{"rain"},
\code{"saw"}, \code{"shingle"}, \code{"rshingle"}, \code{"stripe"}, or \code{"wave"}.
\item These names support partial matching, e.g. \code{"her"}, \code{"herring"}, and
\code{"herringbone"} are all valid. However, tiling designs may be added in
the future, so it is recommended to use the full names in finished code.
}

\strong{Angle modifier:}
\itemize{
\item A number immediately following the tiling design, such as \code{"stripe45"},
\code{"fish180"}, or \code{"saw20"}.
\item Is added to the \code{angle} argument; \code{fill_pattern("brick45", angle=45)} is
equivalent to \code{fill_pattern("brick90")}.
}

\strong{Width and height modifier:}
\itemize{
\item An underscore followed by a single size to be used for both width and height.
\item Or, an underscore followed by the new width and height separated by a colon.
\item Can be absolute sizes (\code{"grid_4"} or \code{"hex_5mm:0.1npc"}) or relative to
the \code{width} and \code{height} arguments (\code{"saw_sm"} or \code{"brick_*2:/2"}). The
shorthand values \code{"xs"}, \code{"sm"}, \code{"md"}, \code{"lg"}, and \code{"xl"} are equivalent
to \code{"/4"}, \code{"/2"}, \code{"1"}, \code{"*2"}, and \code{"*4"}, respectively.
}

\strong{Line width and style:}
\itemize{
\item An underscore, followed by a number, followed by one of \code{"solid"},
\code{"dashed"}, \code{"dotted"}, \code{"dotdash"}, \code{"longdash"}, or \code{"twodash"}. For
example, \code{"shingle_0.5dashed"} or \code{"wave_2solid"}.
\item The number component is optional, so \code{"oct_longdash"} is also valid, and
will use \code{lwd} for the line width.
\item To specify just the line width, suffix the number with "lwd":
\code{"grid_2lwd"} will use \code{lty} for the line style.
}

\strong{Combinations:}
\itemize{
\item Modifiers can be combined in any order. For example, \code{"hex_lg:xl_2dotted"}
or \code{"grid45_dashed_1.4lwd_:6mm_sm:"}.
}
}

\examples{
 \donttest{
    library(ggplot2)
    library(fillpattern)
    
    ggplot(mpg, aes(x = class, y = hwy, color = class, fill = class)) +
      geom_boxplot() +
      scale_fill_pattern()

    ggplot(mpg, aes(x = drv, y = hwy, color = drv, fill = drv)) +
      geom_violin() +
      scale_colour_brewer(palette = "Set1") + 
      scale_fill_pattern(c("brick", "stripe45", "grid45_lg"), fg = "black")

    ggplot(mpg, aes(x = drv, color = drv, fill = drv)) +
      geom_bar() +
      scale_fill_pattern(
        patterns = c("hex_sm", "brick90_xl", "fish"),
        lty      = c("solid", "twodash", "dotted"),
        lwd      = c(2, 3, 1) ) +
      theme(legend.key.size = unit(2, 'cm'))
 }
}
\seealso{
\code{\link[=fill_pattern]{fill_pattern()}} for base \code{grid} graphics integration.
}
