% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make_path.R
\name{make_path}
\alias{make_path}
\alias{make_path.character}
\alias{make_path.filename}
\title{Create directory structure for a file path}
\usage{
make_path(x, ...)

\method{make_path}{filename}(x, showWarnings = FALSE, recursive = TRUE, ...)

\method{make_path}{character}(x, ...)
}
\arguments{
\item{x}{file name (\code{character} or \code{filename})}

\item{...}{other arguments passed to \code{\link{dir.create}}}

\item{showWarnings}{whether to show warnings}

\item{recursive}{whether to recursively create all parent directories}
}
\description{
This function creates directories recursively (as necessary) to the
specified file.
}
\examples{
\dontrun{
# CRAN policy forbids package example to write to current directory,
# even inside \dontrun because the user may copy-and-paste and
# polute his/her current directory;
# in real-world setting, the `tempdir` path prefix is unnecessary
x <- file.path(tempdir(), "path/to/file.txt")

fn <- as.filename(x)
make_path(fn)
}
}

