% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_posterior_density.R
\name{coef_posterior_density}
\alias{coef_posterior_density}
\title{Plots the posterior density for the fergm model terms}
\usage{
coef_posterior_density(fergm.fit = NULL, custom_var_names = NULL)
}
\arguments{
\item{fergm.fit}{Output object from the fergm function.}

\item{custom_var_names}{Custom variable names to use that match the order of the form object passed to FERGM.}
}
\value{
This prints a list of posterior density plots.
}
\description{
This function allows the users to examine the posterior density of FERGM model terms.
}
\examples{
# load example data
data("ergm.fit")
data("fergm.fit")
data("mesa")

# You can also look at the density of particular variables
  # using the following built in rstan functions:
plot(fergm.fit$stan.fit, par = "beta")
# Histogram of the posterior
stan_hist(fergm.fit$stan.fit, par = "beta")
# Density of the posteriors
stan_dens(fergm.fit$stan.fit, par = "beta")

# We have a cleaner function to look at the posterior densities
densities <- coef_posterior_density(fergm.fit = fergm.fit,
custom_var_names = c("Edges", "Sex Homophily", "Grade Homophily", "Race Homophily",
"GWESP", "Alternating K-Stars"))
densities[[1]]
densities[[2]]
}
\references{
Box-Steffensmeier, Janet M., Dino P. Christenson, and Jason W. Morgan. 2017. ``Modeling Unobserved Heterogeneity in Social Networks with the Frailty Exponential Random Graph Model." \emph{Political Analysis}.

Stan Development Team (2016). RStan: the R interface to Stan. R package version 2.14.1. \url{http://mc-stan.org/}.
}
\keyword{FERGM}
\keyword{interpret}
\keyword{summary}
