% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_check_data_update_.R
\name{fedstat_check_data_update_}
\alias{fedstat_check_data_update_}
\title{Compares reference_data and new_data for any changes}
\usage{
fedstat_check_data_update_(
  indicator_id,
  reference_data_ids_unfiltered_special_cases_handled,
  reference_data_df,
  ...,
  filters = list(),
 
    time_filter_fields_titles = c("\\\\u041f\\\\u0435\\\\u0440\\\\u0438\\\\u043e\\\\u0434",
    "\\\\u0413\\\\u043e\\\\u0434"),
  time_fields_titles_in_df = c("PERIOD", "Time"),
  filter_value_title_alias_lookup_table = data.frame(filter_value_title = character(),
    filter_value_title_alias = character(), stringsAsFactors = FALSE),
  timeout_seconds = 180,
  retry_max_times = 3,
  disable_warnings = FALSE,
  httr_verbose = httr::verbose(data_out = FALSE)
)
}
\arguments{
\item{indicator_id}{character, indicator id/code from indicator URL.
For example for indicator with URL https://www.fedstat.ru/indicator/37426 indicator id will be 37426}

\item{reference_data_ids_unfiltered_special_cases_handled}{data_ids of reference_data
without filtering and with special cases handled}

\item{reference_data_df}{data_df of reference_data}

\item{...}{other arguments passed to httr::GET and httr::POST}

\item{filters}{JSON in R list form. The structure should be like this:

\preformatted{
{
 "filter_field_title1": ["filter_value_title1", "filter_value_title2"],
 "filter_field_title2": ["filter_value_title1", "filter_value_title2"],
 ...
}
}

Where for example \code{filter_field_title1} could be a string "Year" with
\code{filter_value_title1} equal to 2020 and \code{filter_field_title2}
could be a string "OKATO" with \code{filter_value_title1}
equal to "Russian Federation"
Not actual filter field titles and filter values titles
because of ASCII requirement for CRAN}

\item{time_filter_fields_titles}{character, title names of time filter fields
in \code{filters} list, currently only default values are allowed}

\item{time_fields_titles_in_df}{character, title names of time related columns
in \code{data_df} (result of \code{fedstat_parse_sdmx_to_table}), currently only default values are allowed}

\item{filter_value_title_alias_lookup_table}{data.frame with columns \code{filter_value_title} and \code{filter_value_title_alias}.
Used to replace \code{filter_value_title} with standard forms of filter value titles.
It is mainly used to set consistent names.
For example, the Dalnevostochnyj federalnyj okrug ( s 03.11.2018) (transliteration for CRAN) in \code{filter_value_title}
can be simply replaced with \code{filter_value_title_alias} as Dalnevostochnyj federalnyj okrug.
In this example in fact, these are two different entities (after the inclusion of Buryatia and Transbaikalia and before),
but in most cases such a replacement is more convenient for loading data, since you need the whole time series.
By default it's empty data.frame, e.g. no replacement for anything.}

\item{timeout_seconds}{numeric, maximum time before a new GET and POST request is tried}

\item{retry_max_times}{numeric, maximum number of tries to GET and POST \code{data_ids}}

\item{disable_warnings}{bool, enables or disables following warnings:
\enumerate{
\item About non matched \code{filter_value_title} in \code{filters} and \code{filter_value_title} from \code{data_ids};
\item About unspecified \code{filter_filed_title} in filters.
}}

\item{httr_verbose}{\code{httr::verbose()} or NULL, outputs messages to the console
about the processing of the request}
}
\value{
bool, TRUE if indicator data has been updated, FALSE if not
}
\description{
Compares reference_data and new_data for any changes
}
