% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_features.R
\name{save_features}
\alias{save_features}
\title{Save features}
\usage{
save_features(.data, filename = NA, path = NA)
}
\arguments{
\item{.data}{The tibble of features returned from \link[featuretoolsR]{extract_features}.}

\item{filename}{(optional) The name of the file to produce.}

\item{path}{(optional) The path where the feature file should be placed.}
}
\description{
Used to save all or a subset of features created during \link[featuretoolsR]{dfs}.
}
\examples{
\donttest{
library(magrittr)
set_1 <- data.frame(key = 1:100, value = sample(letters, 100, TRUE), stringsAsFactors = TRUE)
set_2 <- data.frame(key = 1:100, value = sample(LETTERS, 100, TRUE), stringsAsFactors = TRUE)
# Common variable: `key`

dir <- tempdir()
as_entityset(set_1, index = "key", entity_id = "set_1", id = "demo") \%>\%
  add_entity(entity_id = "set_2", df = set_2, index = "key") \%>\%
  add_relationship(
    parent_set = "set_1",
    child_set = "set_2",
    parent_idx = "key",
    child_idx = "key"
  ) \%>\%
  dfs(target_entity = "set_1", trans_primitives = c("and")) \%>\%
  extract_features() \%>\%
  save_features(filename = "some.features", path = dir)
}
}
