% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{vectorize.docs}
\alias{vectorize.docs}
\title{Document vectorization}
\usage{
vectorize.docs(vectorizer = NULL, corpus = NULL, lang = "en",
  stopwords = lang, ngram = 1, mincount = 10,
  minphrasecount = NULL, transform = c("tfidf", "lsa", "l1", "none"),
  latentdim = 50, returndata = TRUE, ...)
}
\arguments{
\item{vectorizer}{The document vectorizer.}

\item{corpus}{The corpus of documents (a vector of characters).}

\item{lang}{The language of the documents (NULL if no stemming).}

\item{stopwords}{Stopwords, or the language of the documents. NULL if stop words should not be removed.}

\item{ngram}{maximum size of n-grams.}

\item{mincount}{Minimum word count to be considered as frequent.}

\item{minphrasecount}{Minimum collocation of words count to be considered as frequent.}

\item{transform}{Transformation (TF-IDF, LSA, L1 normanization, or nothing).}

\item{latentdim}{Number of latent dimensions if LSA transformation is performed.}

\item{returndata}{If true, the vectorized documents are returned. If false, a "vectorizer" is returned.}

\item{...}{Other parameters.}
}
\value{
The vectorized documents.
}
\description{
Vectorize a corpus of documents.
}
\examples{
\dontrun{
require (text2vec)
data ("movie_review")
# Clustering
docs = vectorize.docs (corpus = movie_review$review, transform = "tfidf")
km = KMEANS (docs [sample (nrow (docs), 100), ], k = 10)
# Classification
d = movie_review [, 2:3]
d [, 1] = factor (d [, 1])
d = splitdata (d, 1)
vectorizer = vectorize.docs (corpus = d$train.x,
                             returndata = FALSE, mincount = 50)
train = vectorize.docs (corpus = d$train.x, vectorizer = vectorizer)
test = vectorize.docs (corpus = d$test.x, vectorizer = vectorizer)
model = NB (as.matrix (train), d$train.y)
pred = predict (model, as.matrix (test))
evaluation (pred, d$test.y)
}
}
\seealso{
\code{\link{query.docs}}, \code{\link[stopwords]{stopwords}}, \code{\link[text2vec]{vectorizers}}
}
