% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateBasis.R
\name{CreateBasis}
\alias{CreateBasis}
\title{Create an orthogonal basis of K functions in [0, 1], with nGrid points.}
\usage{
CreateBasis(K, pts = seq(0, 1, length.out = 50), type = c("cos", "sin",
  "fourier", "legendre01", "poly"))
}
\arguments{
\item{K}{A positive integer specifying the number of eigenfunctions to generate.}

\item{pts}{A vector specifying the time points to evaluate the basis functions.}

\item{type}{A string for the type of orthogonal basis.}
}
\value{
A K by nGrid matrix, each column containing an basis function.
}
\description{
Create an orthogonal basis of K functions in [0, 1], with nGrid points.
}
\examples{
basis <- CreateBasis(3, type='fourier')
head(basis)

}
