function [H_f1, H_f2, Hc_OK, ...
      Hc_Next, Hc_Last, Hc_This, Hc_Enter, Hc_Quit,  ...
      Hc_Height, Hc_Velocity, Hc_Accel, Hc_Residual, ...
      Hc_Male, Hc_Female, Hc_CaseNo] = ...
      menusetup(icase, malestr, femalestr)

%  figure for plotting

H_f1 = figure;
left=50; bottom=50; width=700; height=500;
Position1 = [left, bottom, width, height];
set(H_f1,'Position', Position1)

%  figure for case and plot selection menu

H_f2 = figure;
left = left+750; width=200; bottom=350; height=200;
Position2 = [left, bottom, width, height];
set(H_f2,'Position', Position2,'MenuBar',menubar)

%  OK pushbutton for launching plot

Hc_OK = uicontrol(H_f2,       ...
   'Style',    'pushbutton',  ...
   'Position', [80,20,40,20], ...
   'String',   'OK',          ...
   'CallBack', [ ...
      'icase=growthplot(icase,H_f1,',             ...
      'Hc_Next, Hc_Last, Hc_This, Hc_Enter, Hc_Quit,',  ...
      'Hc_Height, Hc_Velocity, Hc_Accel, Hc_Residual,', ...
      'Hc_Male, Hc_Female, Hc_CaseNo, malestr, femalestr);']);

%  radiobuttons for index of next case

Hc_Next = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,180,50,10], ...
   'String', 'Next',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',1),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_Last = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,160,50,10], ...
   'String', 'Last',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',1),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_This = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,140,50,10], ...
   'String', 'This',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',1),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_Enter = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,120,50,10], ...
   'String', 'Enter',           ...
   'Value', 1,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',1),' ...
      'set(Hc_Quit,  ''Value'',0);']);
Hc_Quit = uicontrol(H_f2,      ...
   'Style', 'radiobutton',     ...
   'Position', [20,100,50,10], ...
   'String', 'Quit;',           ...
   'Value', 0,                 ...
   'CallBack', [...
      'set(Hc_Next,  ''Value'',0),' ...
      'set(Hc_Last,  ''Value'',0),' ...
      'set(Hc_This,  ''Value'',0),' ...
      'set(Hc_Enter, ''Value'',0),' ...
      'set(Hc_Quit,  ''Value'',1);']);

%  radiobuttons for derivative

Hc_Height = uicontrol(H_f2,     ...
   'Style', 'radiobutton',      ...
   'Position', [100,180,80,10], ...
   'String', 'Height',          ...
   'Value', 1,                  ...
   'CallBack', [...
      'set(Hc_Height,   ''Value'',1),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_Velocity = uicontrol(H_f2,   ...
   'Style', 'radiobutton',      ...
   'Position', [100,160,80,10], ...
   'String', 'Velocity',        ...
   'Value', 0,                  ...
   'CallBack', [...
      'set(Hc_Height,   ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',1),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_Accel = uicontrol(H_f2,      ...
   'Style',    'radiobutton',   ...
   'Position', [100,140,80,10], ...
   'String',   'Acceleration',  ...
   'Value',    0,               ...
   'CallBack', [...
      'set(Hc_Height,   ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',1),', ...
      'set(Hc_Residual, ''Value'',0),']);
Hc_Residual = uicontrol(H_f2,      ...
   'Style',    'radiobutton',   ...
   'Position', [100,120,80,10], ...
   'String',   'Residual',  ...
   'Value',    0,               ...
   'CallBack', [...
      'set(Hc_Height,   ''Value'',0),', ...
      'set(Hc_Velocity, ''Value'',0),', ...
      'set(Hc_Accel,    ''Value'',0),', ...
      'set(Hc_Residual, ''Value'',1),']);

%  radiobuttons for gender

Hc_Male = uicontrol(H_f2,      ...
   'Style',    'radiobutton',  ...
   'Position', [20,60,50,10],  ...
   'String',   'Male',         ...
   'Value',    1,              ...
   'CallBack', [...
      'set(Hc_Male,   ''Value'', 1),', ...
      'set(Hc_Female, ''Value'', 0);']);
Hc_Female = uicontrol(H_f2,    ...
   'Style',    'radiobutton',  ...
   'Position', [100,60,50,10], ...
   'String',   'Female',       ...
   'Value',    0,              ...
   'CallBack', [...
      'set(Hc_Male,   ''Value'', 0),', ...
      'set(Hc_Female, ''Value'', 1);']);


%  editable text box for case number

Hc_CaseNo = uicontrol(H_f2,    ...
   'Style',    'edit',         ...
   'Position', [100,90,75,20], ...
   'String',   num2str(icase), ...
   'Value',    icase);
