% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.dist.R
\name{metric.dist}
\alias{metric.dist}
\title{Distance Matrix Computation}
\usage{
metric.dist(x, y = NULL, method = "euclidean", p = 2, dscale = 1, ...)
}
\arguments{
\item{x}{Data frame 1. The dimension is (\code{n1} x \code{m}).}

\item{y}{Data frame 2. The dimension is (\code{n2} x \code{m}).}

\item{method}{The distance measure to be used. This must be one of
"euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{p}{The power of the Minkowski distance.}

\item{dscale}{If scale is a numeric, the distance matrix is divided by the
scale value. If scale is a function (as the mean for example) the distance
matrix is divided by the corresponding value from the output of the
function.}

\item{\dots}{Further arguments passed to \code{\link{dist}} function.}
}
\description{
This function computes the distances between the rows of a data matrix by
using the specified distance measure.

This function returns a distance matrix by using \code{\link{dist}}
function. \cr The matrix dimension is (\code{n1} x \code{n1}) if
\code{y=NULL}, (\code{n1} x \code{n2}) otherwise.
}
\examples{
\dontrun{
data(iris)
d<-metric.dist(iris[,1:4])
matplot(d,type="l",col=as.numeric(iris[,5]))
}
}
\seealso{
See also \code{\link{dist}} for multivariate date case and
\code{\link{metric.lp} for functional data case}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{cluster}
