% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrogate_tree.R
\name{surrogate_tree}
\alias{surrogate_tree}
\title{Fit a surrogate decision tree for a fastml model}
\usage{
surrogate_tree(object, maxdepth = 3, ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{maxdepth}{Maximum depth of the surrogate tree. Default 3.}

\item{...}{Additional arguments passed to `iml::TreeSurrogate`.}
}
\value{
An `iml::TreeSurrogate` object.
}
\description{
Builds an interpretable tree approximating the behaviour of the underlying
model using the `iml` package.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
surrogate_tree(model)
}
}
