% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union.r
\name{union,GVector,GVector-method}
\alias{union,GVector,GVector-method}
\alias{union}
\title{Combine two GVectors}
\usage{
\S4method{union}{GVector,GVector}(x, y)
}
\arguments{
\item{x, y}{\code{GVector}s representing polygons.}
}
\value{
A \code{GVector}.
}
\description{
The \code{union()} function combines two "polygons" \code{GVector}s. The output will have at least as many geometries as both \code{GVector}s, plus more if polygons of one divide polygons of the other, and vice versa. You can also use the \code{+} operator (e.g., \code{vect1 + vect2}).
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Polygon of coastal Madagascar and Dypsis specimens
madCoast4 <- fastData("madCoast4") # polygons
madDypsis <- fastData("madDypsis") # points

# Convert vectors:
coast4 <- fast(madCoast4)
dypsis <- fast(madDypsis)

# Create another polygons vector from a convex hull around Dypsis points
hull <- convHull(dypsis)

### union()

unioned <- union(coast4, hull)
plot(unioned)

plus <- coast4 + hull # same as union()

### intersect

inter <- intersect(coast4, hull)
plot(coast4)
plot(hull, border = "red", add = TRUE)
plot(inter, border = "blue", add = TRUE)

### xor

xr <- xor(coast4, hull)
plot(coast4)
plot(xr, border = "blue", add = TRUE)

### erase

erased <- erase(coast4, hull)
plot(coast4)
plot(erased, border = "blue", add = TRUE)

minus <- coast4 - hull # same as erase()

}
}
\seealso{
\code{\link[=c]{c()}}, \code{\link[=aggregate]{aggregate()}}, \code{\link[=crop]{crop()}}, \code{\link[=intersect]{intersect()}}, \code{\link[=xor]{xor()}}, \code{\link[=erase]{erase()}}
}
