% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectors.r
\name{connectors,GVector,GVector-method}
\alias{connectors,GVector,GVector-method}
\alias{connectors}
\title{Create lines connecting nearest features of two GVectors}
\usage{
\S4method{connectors}{GVector,GVector}(x, y, minDist = NULL, maxDist = NULL)
}
\arguments{
\item{x, y}{\code{GVector}s.}

\item{minDist, maxDist}{Either \code{NULL} (default) or numeric values: Ignore features separated by less than or greater than these distances.}
}
\value{
A \code{GVector} with a data table that has the length of each connecting line in meters.
}
\description{
\code{connectors()} creates a lines \code{GVector} which represent the shortest (Great Circle) paths between each feature of one \code{GVector} and the nearest feature of another \code{GVector}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Rivers vector and locations of Dypsis plants
madRivers <- fastData("madRivers")
madDypsis <- fastData("madDypsis")

# Convert sf's to GVectors:
dypsis <- fast(madDypsis)
rivers <- fast(madRivers)

### Connections from each point to nearest river
consFromDypsis <- connectors(dypsis, rivers)

plot(rivers, col = "blue")
plot(dypsis, add = TRUE)
plot(consFromDypsis, col = "red", add = TRUE)

### Connections from each river to nearest point
consFromRivers <- connectors(rivers, dypsis)

plot(rivers, col = "blue")
plot(dypsis, add = TRUE)
plot(consFromRivers, col = "red", add = TRUE)

}
}
\seealso{
\strong{GRASS} manual for tool \code{v.distance} (see \code{grassHelp("v.distance")}).
}
