% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streams.r
\name{streams,GRaster-method}
\alias{streams,GRaster-method}
\alias{streams}
\title{Create stream network}
\usage{
\S4method{streams}{GRaster}(
  x,
  accumulation = NULL,
  depression = NULL,
  flowThreshold = 1,
  dirThreshold = 1,
  montgomery = 0,
  minLength = 1
)
}
\arguments{
\item{x}{A \code{GRaster} representing elevation.}

\item{accumulation}{Either \code{NULL} (default) or a raster representing flow accumulation. If not supplied, an accumulation will created internally. You can generate an accumulation raster using \code{\link[=flow]{flow()}}.}

\item{depression}{Either \code{NULL} (default) or a \code{GRaster} representing depressions (areas from which streams will not flow out of).}

\item{flowThreshold}{Numeric > 0: Minimum threshold for a stream to be generated. The default is 1, which is not necessarily a reasonable value.}

\item{dirThreshold}{Numeric (default is \code{Inf}): When flow exceeds this threshold, its direction is estimated using a single-flow direction algorithm. Below this threshold, a multi-direction flow model is used. This is the \code{d8cut} parameter in \code{r.stream.extract}, and it is only used if \code{accumulation} is \code{NULL}.  The default is 1, which is not necessarily a reasonable value.}

\item{montgomery}{Numeric: The "Montgomery" exponent for slope, multiplied by accumulation as per \code{accumulation * slope^montgomery}. This value is then compared to the threshold to determine if it is sufficient. The default is 0 (i.e., no slope scaling).}

\item{minLength}{Numeric: First-order streams less than this length are removed (units in cells). Default is 0 (no removal).}
}
\value{
A \code{GRaster}.
}
\description{
This function estimates the course of streams and rivers from an elevation raster. It is based on the \strong{GRASS} module \code{r.stream.extract}, where more details can be found (see \code{grassHelp("r.stream.extract")})
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)

# Calculate stream channels
streams <- streams(elev)
plot(streams)

}
}
\seealso{
\code{\link[=flow]{flow()}}, \code{\link[=flowPath]{flowPath()}}, \strong{GRASS} manual for module \code{r.stream.extract} (see \code{grassHelp("r.stream.extract")})
}
