% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot,GRaster,missing-method}
\alias{plot,GRaster,missing-method}
\alias{plot}
\alias{plot,GVector,missing-method}
\title{Display a raster or vector}
\usage{
\S4method{plot}{GRaster,missing}(x, y, simplify = TRUE, ...)

\S4method{plot}{GVector,missing}(x, y, maxGeoms = 10000, ...)
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector}.}

\item{y}{Missing--leave as empty.}

\item{simplify}{Logical: If \code{TRUE} (default) and the raster has an x- and/or y-resolution that is greater than the screen resolution, then \code{\link[=aggregate]{aggregate()}} will be applied to the raster before it is saved to reduce the time it takes to save the raster.}

\item{...}{Other arguments to send to \code{\link[terra:plot]{terra::plot()}}.}

\item{maxGeoms}{Positive integer (vectors only): Maximum number of features before vector simplification is applied before saving to disk then creating a \code{SpatVector} for plotting. The default is 10000.}
}
\value{
Nothing (displays a raster or vector).
}
\description{
\code{plot()} displays a \code{GRaster} or \code{GVector}.

This function is essentially a hack, as it it not possible to dependably call the appropriate \strong{GRASS} modules and display a raster or vector without potential confusion on the user side. Instead, this function 1) simplifies the focal \code{GRaster} or \code{GVector} to make it smaller when saved to disk; 2) writes the object to disk; 3) (internally) creates a \code{SpatRaster} or \code{SpatVector} object; then 4) plots the object using \code{\link[terra:plot]{terra::plot()}}. Thus, if you are interested in making maps, it will always be faster to make them directly with \strong{terra} or \strong{sf}.
}
\examples{
if (grassStarted()) {

# Example data
madElev <- fastData("madElev") # elevation raster
madLANDSAT <- fastData("madLANDSAT") # multi-layer raster
madRivers <- fastData("madRivers") # lines vector

# Convert SpatRaster to GRaster and SpatVector to GVector
elev <- fast(madElev)
rivers <- fast(madRivers)
landsat <- fast(madLANDSAT)

# Plot:
plot(elev)
plot(rivers, add = TRUE)

# Histograms:
hist(elev)
hist(landsat)

# Plot surface reflectance in RGB:
plotRGB(landsat, 3, 2, 1) # "natural" color
plotRGB(landsat, 4, 1, 2, stretch = "lin") # emphasize near-infrared (vegetation)

# Make composite map from RGB layers and plot in grayscale:
comp <- compositeRGB(r = landsat[[3]], g = landsat[[2]], b = landsat[[1]])
grays <- paste0("gray", 0:100)
plot(comp, col = grays)

}
}
\seealso{
\code{\link[terra:plot]{terra::plot()}}
}
