% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext.r
\name{ext,missing-method}
\alias{ext,missing-method}
\alias{ext}
\alias{ext,GSpatial-method}
\alias{zext,missing-method}
\alias{zext}
\alias{zext,GSpatial-method}
\alias{W,missing-method}
\alias{W}
\alias{W,GSpatial-method}
\alias{E,missing-method}
\alias{E}
\alias{E,GSpatial-method}
\alias{N,missing-method}
\alias{N}
\alias{N,GSpatial-method}
\alias{S,missing-method}
\alias{S}
\alias{S,GSpatial-method}
\alias{top,missing-method}
\alias{top}
\alias{top,GSpatial-method}
\alias{bottom,GSpatial-method}
\alias{bottom}
\title{Spatial bounds of a GRaster or GVector}
\usage{
\S4method{ext}{missing}(x, vector = FALSE)

\S4method{ext}{GSpatial}(x, vector = FALSE)

\S4method{zext}{missing}(x)

\S4method{zext}{GSpatial}(x)

\S4method{W}{missing}(x, char = FALSE)

\S4method{W}{GSpatial}(x, char = FALSE)

\S4method{E}{missing}(x, char = FALSE)

\S4method{E}{GSpatial}(x, char = FALSE)

\S4method{N}{missing}(x, char = FALSE)

\S4method{N}{GSpatial}(x, char = FALSE)

\S4method{S}{missing}(x, char = FALSE)

\S4method{S}{GSpatial}(x, char = FALSE)

\S4method{top}{missing}(x, char = FALSE)

\S4method{top}{GSpatial}(x, char = FALSE)

\S4method{bottom}{GSpatial}(x, char = FALSE)

\S4method{bottom}{GSpatial}(x, char = FALSE)
}
\arguments{
\item{x}{An object that inherits from \code{GSpatial} (i.e., a \code{GRaster} or \code{GVector}) or missing. If missing, then the horizontal or vertical extent of the currently active "region" is returned (see \code{vignette("regions", package = "fasterRaster")}).}

\item{vector}{Logical: If \code{FALSE} (default), return a \code{SpatExtent} object. If \code{TRUE}, return the extent as a named vector.}

\item{char}{Logical: If \code{FALSE} (default), return a numeric value. If \code{TRUE}, return as a character.}
}
\value{
The returned values depend on the function:
\itemize{
\item \code{ext()}: A \code{SpatExtent} object (\strong{terra} package) or a numeric vector.
\item \code{zext()}: A numeric vector.
\item \code{W()}, \code{E()}, \code{N()}, \code{S()}, \code{top()}, and \code{bottom()}: A numeric value or character.
}
}
\description{
These functions return the extent of a \code{GSpatial} object (\code{GRegions}, \code{GRaster}s, and \code{GVector}s):
\itemize{
\item \code{ext()}: 2-dimensional spatial extent (i.e., westernmost/easternmost and southernmost/northernmost coordinates of area represented).\cr
\item \code{zext()}: Vertical extent (i.e., topmost and bottom-most elevation of the volume represented). The vertical extent is not \code{NA} only if the object is 3-dimensional.\cr
\item \code{W()}, \code{E()}, \code{N()}, \code{S()}: Coordinates of one side of horizontal extent.\cr
\item \code{top()} and \code{bottom()}: Coordinates of top and bottom of vertical extent.\cr
}
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev")
madForest2000 <- fastData("madForest2000")
madCoast0 <- fastData("madCoast0")
madRivers <- fastData("madRivers")
madDypsis <- fastData("madDypsis")

### GRaster properties

# convert SpatRasters to GRasters
elev <- fast(madElev)
forest <- fast(madForest2000)

# plot
plot(elev)

dim(elev) # rows, columns, depths, layers
nrow(elev) # rows
ncol(elev) # columns
ndepth(elev) # depths
nlyr(elev) # layers

res(elev) # resolution

ncell(elev) # cells
ncell3d(elev) # cells (3D rasters only)

topology(elev) # number of dimensions
is.2d(elev) # is it 2D?
is.3d(elev) # is it 3D?

minmax(elev) # min/max values

# name of object in GRASS
sources(elev)

# "names" of the object
names(elev)

# coordinate reference system
crs(elev)

# extent (bounding box)
ext(elev)

# data type
datatype(elev)

# assigning
copy <- elev
copy[] <- pi # assign all cells to the value of pi
copy

# concatenating multiple GRasters
rasts <- c(elev, forest)
rasts

# adding a raster "in place"
add(rasts) <- ln(elev)
rasts

# subsetting
rasts[[1]]
rasts[["madForest2000"]]

# assigning
rasts[[4]] <- elev > 500

# number of layers
nlyr(rasts)

# names
names(rasts)
names(rasts) <- c("elev_meters", "forest", "ln_elev", "high_elevation")
rasts

### GVector properties

# convert sf vectors to GVectors
coast <- fast(madCoast4)
rivers <- fast(madRivers)
dypsis <- fast(madDypsis)

# extent
ext(rivers)

W(rivers) # western extent
E(rivers) # eastern extent
S(rivers) # southern extent
N(rivers) # northern extent
top(rivers) # top extent (NA for 2D rasters like this one)
bottom(rivers) # bottom extent (NA for 2D rasters like this one)

# coordinate reference system
crs(rivers)
st_crs(rivers)

# column names and data types
names(coast)
datatype(coast)

# name of object in GRASS
sources(rivers)

# points, lines, or polygons?
geomtype(dypsis)
geomtype(rivers)
geomtype(coast)

is.points(dypsis)
is.points(coast)

is.lines(rivers)
is.lines(dypsis)

is.polygons(coast)
is.polygons(dypsis)

# dimensions
nrow(rivers) # how many spatial features
ncol(rivers) # hay many columns in the data frame

# number of geometries and sub-geometries
ngeom(coast)
nsubgeom(coast)

# 2- or 3D
topology(rivers) # dimensionality
is.2d(elev) # is it 2D?
is.3d(elev) # is it 3D?

# Update values from GRASS
# (Reads values from GRASS... will not appear to do anything in this case)
coast <- update(coast)

### operations on GVectors

# convert to data frame
as.data.frame(rivers)
as.data.table(rivers)

# subsetting
rivers[c(1:2, 5)] # select 3 rows/geometries
rivers[-5:-11] # remove rows/geometries 5 through 11
rivers[ , 1] # column 1
rivers[ , "NAM"] # select column
rivers[["NAM"]] # select column
rivers[1, 2:3] # row/geometry 1 and column 2 and 3
rivers[c(TRUE, FALSE)] # select every other geometry (T/F vector is recycled)
rivers[ , c(TRUE, FALSE)] # select every other column (T/F vector is recycled)

# removing data table
noTable <- dropTable(rivers)
noTable
nrow(rivers)
nrow(noTable)

# Refresh values from GRASS
# (Reads values from GRASS... will not appear to do anything in this case
# since the rivers object is up-to-date):
rivers <- update(rivers)

# Concatenating multiple vectors
rivers2 <- rbind(rivers, rivers)
dim(rivers)
dim(rivers2)

}
}
\seealso{
\code{\link[terra:ext]{terra::ext()}}, \code{\link[sf:st_bbox]{sf::st_bbox()}}
}
