% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_dollar.r
\docType{methods}
\name{$<-}
\alias{$<-}
\alias{$<-,GRaster-method}
\alias{$<-,GVector-method}
\title{Replace a raster layer or a column from a vector's data table}
\usage{
\S4method{$}{GRaster}(x, name) <- value

\S4method{$}{GVector}(x, name) <- value
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector}.}

\item{name}{Character: Name of the \code{GRaster} layer to replace, or name of the \code{GVector} column to replace.}

\item{value}{Character: The name of a \code{GRaster} layer or the name of a column in a \code{GVector}'s data table. Names of rasters and vector tables' columns cab be obtained using \code{\link[=names]{names()}}.}
}
\value{
A \code{GRaster} or the column of a \code{GVector}.
}
\description{
The \verb{$<-} notation can be used to replace a specific layer in a multi-layer \code{GRaster}, or a to replace a specific column from a \code{GVector}'s data table.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

### GRasters

# Example data
madElev <- fastData("madElev") # elevation raster
madForest2000 <- fastData("madForest2000") # forest raster
madForest2014 <- fastData("madForest2014") # forest raster

# Convert SpatRasters to GRasters
elev <- fast(madElev)
forest2000 <- fast(madForest2000)
forest2014 <- fast(madForest2014)

# Re-assigning values of a GRaster
constant <- elev
constant[] <- pi
names(constant) <- "pi_raster"
constant

# Re-assigning specific values of a raster
replace <- elev
replace[replace == 1] <- -20
replace

# Subsetting specific values of a raster based on another raster
elevInForest <- elev[forest2000 == 1]
plot(c(elev, forest2000, elevInForest), nr = 1)

# Adding and replacing layers of a GRaster
rasts <- c(elev, constant, forest2000)

# Combine with another layer:
add(rasts) <- forest2014 # one way
rasts

rasts <- c(rasts, forest2014) # another way

### Subsetting GRaster layers

# Subset:
rasts <- c(elev, forest2000, forest2014)
rasts[[2:3]]
subset(rasts, 2:3)
subset(rasts, c("madForest2000", "madElev"))
rasts[[c("madForest2000", "madElev")]]
rasts$madForest2000

# Get every other layer:
rasts[[c(FALSE, TRUE)]]

### Replacing layers of a GRaster

# Replace a layer
logElev <- log(elev)
names(logElev) <- "logElev"
rasts$madForest2014 <- logElev
rasts

# Replace a layer:
rasts[[3]] <- forest2000
rasts

### GVectors

# example data
madDypsis <- fastData("madDypsis") # vector of points

# Convert SpatVector to GVector
dypsis <- fast(madDypsis)

### Retrieving GVector columns

dypsis$species # Returns the column

dypsis[[c("year", "species")]] # Returns a GRaster with these columns
dypsis[ , c("year", "species")] # Same as above

### Subsetting GVector geometries

# Subset first three geometries
dypsis[1:3]
dypsis[1:3, "species"]

# Get geometries by data table condition
dypsis[dypsis$species == "Dypsis betsimisarakae"]

### (Re)assigning GVector column values

# New column
dypsis$pi <- pi

# Re-assign values
dypsis$pi <- "pie"

# Re-assign specific values
dypsis$institutionCode[dypsis$institutionCode == "MO"] <-
   "Missouri Botanical Garden"

}
}
\seealso{
\link{$}, \code{\link[fasterRaster]{[[<-}}, and \code{\link[fasterRaster]{add<-}}
}
