% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_lm}
\alias{fastcpd_lm}
\alias{fastcpd.lm}
\title{Find change points efficiently in linear regression models}
\usage{
fastcpd_lm(data, ...)

fastcpd.lm(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_lm]{fastcpd_lm()}} and \code{\link[=fastcpd.lm]{fastcpd.lm()}} are wrapper
functions of \code{\link[=fastcpd]{fastcpd()}} to find change points in linear
regression models. The function is similar to \code{\link[=fastcpd]{fastcpd()}} except that
the data is by default a matrix or data frame with the response variable
as the first column and thus a formula is not required here.
}
\examples{
if (requireNamespace("mvtnorm", quietly = TRUE)) {
  set.seed(1)
  n <- 300
  p <- 4
  x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
  theta_0 <- rbind(c(1, 3.2, -1, 0), c(-1, -0.5, 2.5, -2), c(0.8, 0, 1, 2))
  y <- c(
    x[1:100, ] \%*\% theta_0[1, ] + rnorm(100, 0, 3),
    x[101:200, ] \%*\% theta_0[2, ] + rnorm(100, 0, 3),
    x[201:n, ] \%*\% theta_0[3, ] + rnorm(100, 0, 3)
  )
  result_lm <- fastcpd.lm(cbind(y, x))
  summary(result_lm)
  plot(result_lm)
}
if (requireNamespace("mvtnorm", quietly = TRUE)) {
  set.seed(1)
  n <- 600
  p <- 4
  d <- 2
  x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
  theta_1 <- matrix(runif(8, -3, -1), nrow = p)
  theta_2 <- matrix(runif(8, -1, 3), nrow = p)
  y <- rbind(
    x[1:350, ] \%*\% theta_1 + mvtnorm::rmvnorm(350, rep(0, d), 3 * diag(d)),
    x[351:n, ] \%*\% theta_2 + mvtnorm::rmvnorm(250, rep(0, d), 3 * diag(d))
  )
  result_mlm <- fastcpd.lm(cbind.data.frame(y = y, x = x), p.response = 2)
  summary(result_mlm)
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
