#' @title **NHL Teams**
#' @description Returns NHL Teams information
#' @return Returns a tibble
#' @keywords NHL Teams
#' @import rvest
#' @importFrom rlang .data
#' @importFrom jsonlite fromJSON toJSON
#' @importFrom dplyr mutate filter select rename bind_cols bind_rows
#' @importFrom tidyr unnest unnest_wider everything
#' @importFrom janitor clean_names
#' @export
#' @examples 
#' \donttest{
#'   nhl_teams()
#' }
nhl_teams <- function(){
  
  base_url <- "https://statsapi.web.nhl.com/api/v1/teams/"
  
  full_url <- paste0(base_url)
  
  
  res <- httr::RETRY("GET", full_url)
  
  # Check the result
  check_status(res)
  
  resp <- res %>%
    httr::content(as = "text", encoding = "UTF-8")
  tryCatch(
    expr = {
      teams_df <- jsonlite::fromJSON(resp)[["teams"]]
      teams_df <- jsonlite::fromJSON(jsonlite::toJSON(teams_df),flatten=TRUE)
      teams_df <- teams_df %>% 
        dplyr::rename(team_id = .data$id) %>% 
        janitor::clean_names()
    },
    error = function(e) {
      message(glue::glue("{Sys.time()}: Invalid arguments or no team info data available!"))
    },
    warning = function(w) {
    },
    finally = {
    }
  )
  return(teams_df)
}