% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{mcqrnnQuants}
\alias{mcqrnnQuants}
\title{Compute Quantiles using monotone quantile regression neural networks
(`mcqrnn` package) in the Quantile Learning step.}
\usage{
mcqrnnQuants(
  data,
  A.root,
  ind,
  tau = seq(0.005, 0.995, by = 0.01),
  iter.max = 500,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} with data to be used for quantile
regression.}

\item{A.root}{A \code{logical(1L)} indicating whether the protected
attribute `A` is a root node of the causal graph. Used for splitting the
quantile regression.}

\item{ind}{A \code{logical} vector of length `nrow(data)`, indicating which
samples have the baseline value of the protected attribute.}

\item{tau, iter.max, ...}{Forwarded to [qrnn::mcqrnn.fit()].}
}
\value{
An `mcqrnn` `S3` object.
}
\description{
Compute Quantiles using monotone quantile regression neural networks
(`mcqrnn` package) in the Quantile Learning step.
}
