
#' factorEx: Design and Analysis for Factorial Experiments
#'
#' \code{factorEx} provides design-based and model-based estimators for the population average marginal
#' component effects (the pAMCE) in factorial experiments, including conjoint analysis.
#' The package also implements a series of recommendations offered in de la Cuesta, Egami, and Imai (2019+)
#' and Egami and Imai (2019, JASA).
#'
#' \tabular{ll}{ Package: \tab factorEx\cr Type: \tab Package\cr Version: \tab 1.0.0\cr
#' Date: \tab 2019-09-22\cr}
#'
#' @name factorEx-package
#' @aliases factorEx-package
#' @docType package
#' @author Naoki Egami, Brandon de la Cuesta, Kosuke Imai
#'
#' Maintainer: Naoki Egami \email{naoki.egami5@gmail.com}
#' @references de la Cuesta, Egami, and Imai. (2019+). Improving the External Validity of Conjoint Analysis: The Essential Role of Profile Distribution. (Working Paper). Available at \url{https://scholar.princeton.edu/sites/default/files/negami/files/conjoint_profile.pdf}.
#' @references Egami and Imai. (2019). Causal Interaction in Factorial Experiments: Application to Conjoint Analysis. Journal of the American Statistical Association, Vol.114, No.526 (June), pp. 529–540. Available at \url{https://scholar.princeton.edu/sites/default/files/negami/files/causalint.pdf}.
#' @keywords package
NULL
