% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_decomposition.R
\name{decomposition_model}
\alias{decomposition_model}
\title{Decomposition modelling}
\usage{
decomposition_model(dcmp_fn, formula, ..., dcmp_args = list())
}
\arguments{
\item{dcmp_fn}{The decomposition function}

\item{formula}{The formula used to describe the decomposition}

\item{...}{Model definitions used to model the components}

\item{dcmp_args}{Arguments to be passed to the decomposition function (\code{.dcmp_fn})}
}
\description{
This function allows you to specify a decomposition combination model using
any additive decomposition. It works by first decomposing the data using the
decomposition method provided to \code{dcmp_fn} with the given formula. Secondary
models are used to fit each of the components from the resulting
decomposition. These models are specified after the decomposition formula.
All non-seasonal decomposition components must be specified, and any
unspecified seasonal components will be forecasted using seasonal naive.
These component models will be combined according to the decomposition
method, giving a combination model for the response of the decomposition.
}
\examples{
if (requireNamespace("fable", quietly = TRUE) && requireNamespace("feasts", quietly = TRUE)) {
library(fable)
library(feasts)
library(tsibble)
library(dplyr)

vic_food <- tsibbledata::aus_retail \%>\% 
  filter(State == "Victoria", Industry == "Food retailing")
  
# Identify an appropriate decomposition
vic_food \%>\% 
  STL(log(Turnover) ~ season(window = Inf)) \%>\% 
  autoplot()
  
# Use an ARIMA model to seasonally adjusted data, and SNAIVE to season_year
# Any model can be used, and seasonal components will default to use SNAIVE.
my_dcmp_spec <- decomposition_model(
  STL, log(Turnover) ~ season(window = Inf),
  ETS(season_adjust ~ season("N")), SNAIVE(season_year)
)

vic_food \%>\%
  model(my_dcmp_spec) \%>\% 
  forecast(h="5 years") \%>\% 
  autoplot(vic_food)
}

}
\seealso{
\href{https://otexts.com/fpp3/forecasting-decomposition.html}{Forecasting: Principles and Practice - Forecasting Decomposition}
}
